/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.impl;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.point.impl.ArrayPoint;

public class IdealPoint
extends ArrayPoint {
    public IdealPoint(int dimension) {
        super(dimension);
        Arrays.fill(this.point, Double.POSITIVE_INFINITY);
    }

    @Override
    public void update(double[] point) {
        Check.that(point.length == this.point.length, "The point to be update have a dimension of " + point.length + " while the parameter point has a dimension of " + point.length);
        for (int i = 0; i < point.length; ++i) {
            if (!(this.point[i] > point[i])) continue;
            this.point[i] = point[i];
        }
    }

    public void update(List<? extends Solution<?>> solutionList) {
        for (Solution<?> solution : solutionList) {
            this.update(solution.objectives());
        }
    }
}

