/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.ranking.impl.util;

public class MNDSBitsetManager {
    private static final int FIRST_WORD_RANGE = 0;
    private static final int LAST_WORD_RANGE = 1;
    private static final int N_BIT_ADDR = 6;
    private static final int WORD_SIZE = 64;
    private static final long WORD_MASK = -1L;
    private long[][] bitsets;
    private int[][] bsRanges;
    private int[] wordRanking;
    private int[] ranking;
    private int[] ranking0;
    private int maxRank;
    private long[] incrementalBitset;
    private int incBsFstWord;
    private int incBsLstWord;

    public void freeMem() {
        this.incrementalBitset = null;
        this.bitsets = null;
        this.bsRanges = null;
        this.wordRanking = null;
        this.ranking = null;
        this.ranking0 = null;
    }

    public int[] getRanking() {
        return this.ranking0;
    }

    public boolean updateSolutionDominance(int solutionId) {
        int fw = this.bsRanges[solutionId][0];
        int lw = this.bsRanges[solutionId][1];
        if (lw > this.incBsLstWord) {
            lw = this.incBsLstWord;
        }
        if (fw < this.incBsFstWord) {
            fw = this.incBsFstWord;
        }
        while (fw <= lw && 0L == (this.bitsets[solutionId][fw] & this.incrementalBitset[fw])) {
            ++fw;
        }
        while (fw <= lw && 0L == (this.bitsets[solutionId][lw] & this.incrementalBitset[lw])) {
            --lw;
        }
        this.bsRanges[solutionId][0] = fw;
        this.bsRanges[solutionId][1] = lw;
        if (fw > lw) {
            return false;
        }
        while (fw <= lw) {
            long[] lArray = this.bitsets[solutionId];
            int n = fw;
            lArray[n] = lArray[n] & this.incrementalBitset[fw];
            ++fw;
        }
        return true;
    }

    public void computeSolutionRanking(int solutionId, int initSolId) {
        int fw = this.bsRanges[solutionId][0];
        int lw = this.bsRanges[solutionId][1];
        if (lw > this.incBsLstWord) {
            lw = this.incBsLstWord;
        }
        if (fw < this.incBsFstWord) {
            fw = this.incBsFstWord;
        }
        if (fw > lw) {
            return;
        }
        int i = 0;
        int rank = 0;
        while (fw <= lw) {
            long word = this.bitsets[solutionId][fw] & this.incrementalBitset[fw];
            if (word != 0L) {
                i = Long.numberOfTrailingZeros(word);
                int offset = fw * 64;
                do {
                    if (this.ranking[offset + i] >= rank) {
                        rank = this.ranking[offset + i] + 1;
                    }
                    ++i;
                } while ((i += Long.numberOfTrailingZeros(word >> i)) < 64 && rank <= this.wordRanking[fw]);
                if (rank > this.maxRank) {
                    this.maxRank = rank;
                    break;
                }
            }
            ++fw;
        }
        this.ranking[solutionId] = rank;
        this.ranking0[initSolId] = rank;
        i = solutionId >> 6;
        if (rank > this.wordRanking[i]) {
            this.wordRanking[i] = rank;
        }
    }

    public void updateIncrementalBitset(int solutionId) {
        int wordIndex;
        int n = wordIndex = solutionId >> 6;
        this.incrementalBitset[n] = this.incrementalBitset[n] | 1L << solutionId;
        if (this.incBsLstWord < wordIndex) {
            this.incBsLstWord = wordIndex;
        }
        if (this.incBsFstWord > wordIndex) {
            this.incBsFstWord = wordIndex;
        }
    }

    public boolean initializeSolutionBitset(int solutionId) {
        int wordIndex = solutionId >> 6;
        if (wordIndex < this.incBsFstWord || 0 == solutionId) {
            this.bsRanges[solutionId][0] = Integer.MAX_VALUE;
            return false;
        }
        if (wordIndex == this.incBsFstWord) {
            this.bitsets[solutionId] = new long[wordIndex + 1];
            long intersection = this.incrementalBitset[this.incBsFstWord] & (-1L << solutionId ^ 0xFFFFFFFFFFFFFFFFL);
            if (intersection != 0L) {
                this.bsRanges[solutionId][0] = wordIndex;
                this.bsRanges[solutionId][1] = wordIndex;
                this.bitsets[solutionId][wordIndex] = intersection;
            }
            return intersection != 0L;
        }
        int lw = this.incBsLstWord < wordIndex ? this.incBsLstWord : wordIndex;
        this.bsRanges[solutionId][0] = this.incBsFstWord;
        this.bsRanges[solutionId][1] = lw;
        this.bitsets[solutionId] = new long[lw + 1];
        System.arraycopy(this.incrementalBitset, this.incBsFstWord, this.bitsets[solutionId], this.incBsFstWord, lw - this.incBsFstWord + 1);
        if (this.incBsLstWord >= wordIndex) {
            this.bitsets[solutionId][lw] = this.incrementalBitset[lw] & (-1L << solutionId ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bitsets[solutionId][lw] == 0L) {
                int[] nArray = this.bsRanges[solutionId];
                nArray[1] = nArray[1] - 1;
            }
        }
        return true;
    }

    public void clearIncrementalBitset() {
        this.incrementalBitset = new long[this.incrementalBitset.length];
        this.incBsLstWord = 0;
        this.incBsFstWord = Integer.MAX_VALUE;
    }

    public MNDSBitsetManager(int nSolutions) {
        int n = nSolutions - 1;
        int wordIndex = n >> 6;
        this.ranking = new int[nSolutions];
        this.ranking0 = new int[nSolutions];
        this.wordRanking = new int[nSolutions];
        this.bitsets = new long[nSolutions][];
        this.bsRanges = new int[nSolutions][2];
        this.incrementalBitset = new long[wordIndex + 1];
        this.incBsLstWord = 0;
        this.incBsFstWord = Integer.MAX_VALUE;
    }
}

