/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class AdvancedDifferentialEvolutionCrossover
implements CrossoverOperator<DoubleSolution> {
    private final double cr;
    private final double f;
    private final Variant variant;
    private final RandomGenerator<Double> randomGenerator;
    private final int populationSize;
    private final double pBest;
    private final RepairDoubleSolution solutionRepair;
    private final List<Double> memoryCR;
    private final List<Double> memoryF;
    private final List<DoubleSolution> archive;
    private final int memorySize;
    private int memoryIndex;

    private AdvancedDifferentialEvolutionCrossover(Builder builder) {
        this.cr = builder.cr;
        this.f = builder.f;
        this.variant = builder.variant;
        this.randomGenerator = builder.randomGenerator;
        this.populationSize = builder.populationSize;
        this.pBest = builder.pBest;
        this.solutionRepair = new RepairDoubleSolutionWithBoundValue();
        this.memorySize = builder.memorySize;
        if (this.variant == Variant.SHADE || this.variant == Variant.CURRENT_TO_PBEST_1) {
            this.memoryCR = new ArrayList<Double>(Collections.nCopies(this.memorySize, 0.5));
            this.memoryF = new ArrayList<Double>(Collections.nCopies(this.memorySize, 0.5));
            this.archive = new ArrayList<DoubleSolution>();
            this.memoryIndex = 0;
        } else {
            this.memoryCR = null;
            this.memoryF = null;
            this.archive = null;
        }
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() >= 4, "At least four solutions are required");
        DoubleSolution current = solutions.get(0);
        DoubleSolution trial = (DoubleSolution)current.copy();
        List<DoubleSolution> parents = this.selectParents(solutions, current);
        double currentCR = this.getCR();
        double currentF = this.getF();
        int jRand = JMetalRandom.getInstance().nextInt(0, current.variables().size() - 1);
        for (int i = 0; i < current.variables().size(); ++i) {
            if (!this.shouldApplyCrossover(i, current.variables().size(), currentCR, jRand)) continue;
            double value = this.mutate(parents, i, currentF);
            trial.variables().set(i, this.repairVariableValue(value, current, i));
        }
        if (this.variant == Variant.SHADE || this.variant == Variant.CURRENT_TO_PBEST_1) {
            this.updateArchive(current);
        }
        ArrayList<DoubleSolution> result = new ArrayList<DoubleSolution>(1);
        result.add(trial);
        return result;
    }

    private List<DoubleSolution> selectParents(List<DoubleSolution> population, DoubleSolution current) {
        ArrayList<DoubleSolution> parents = new ArrayList<DoubleSolution>();
        parents.add(current);
        List<DoubleSolution> candidates = new ArrayList<DoubleSolution>(population);
        candidates.remove(current);
        switch (this.variant.ordinal()) {
            case 0: {
                if (candidates.size() < 2) {
                    throw new IllegalArgumentException("At least 3 solutions are required (including current)");
                }
                int idx1 = (int)(this.randomGenerator.getRandomValue() * (double)candidates.size());
                DoubleSolution parent1 = (DoubleSolution)candidates.get(idx1);
                candidates.remove(idx1);
                int idx2 = (int)(this.randomGenerator.getRandomValue() * (double)candidates.size());
                DoubleSolution parent2 = (DoubleSolution)candidates.get(idx2);
                parents.add(parent1);
                parents.add(parent2);
                break;
            }
            case 1: {
                if (candidates.size() < 4) {
                    throw new IllegalArgumentException("At least 5 solutions are required (including current)");
                }
                Collections.shuffle(candidates, new Random(this.randomGenerator.getRandomValue().longValue()));
                parents.addAll(candidates.subList(0, 4));
                break;
            }
            case 2: {
                if (candidates.size() < 3) {
                    throw new IllegalArgumentException("At least 4 solutions are required (including current)");
                }
                Collections.shuffle(candidates, new Random(this.randomGenerator.getRandomValue().longValue()));
                parents.addAll(candidates.subList(0, 3));
                break;
            }
            case 3: 
            case 4: {
                ArrayList<DoubleSolution> sortedPopulation = new ArrayList<DoubleSolution>(population);
                sortedPopulation.sort(Comparator.comparingInt(this::getRank));
                int pBestSize = Math.max(1, (int)((double)population.size() * this.pBest));
                int pBestIndex = (int)(this.randomGenerator.getRandomValue() * (double)pBestSize) % pBestSize;
                DoubleSolution pBestParent = (DoubleSolution)sortedPopulation.get(pBestIndex);
                candidates = population.stream().filter(s -> s != current && s != pBestParent).collect(Collectors.toList());
                Collections.shuffle(candidates);
                parents.add(pBestParent);
                parents.add(candidates.get(0));
                if (this.variant == Variant.SHADE && !this.archive.isEmpty()) {
                    if (!this.archive.isEmpty()) {
                        int archiveIndex = (int)(this.randomGenerator.getRandomValue() * (double)this.archive.size()) % this.archive.size();
                        parents.add(this.archive.get(archiveIndex));
                        break;
                    }
                    parents.add(candidates.get(1));
                    break;
                }
                parents.add(candidates.get(1));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Variant not supported: " + String.valueOf((Object)this.variant));
            }
        }
        return parents;
    }

    private double mutate(List<DoubleSolution> parents, int varIndex, double f) {
        switch (this.variant.ordinal()) {
            case 0: {
                return (Double)parents.get(0).variables().get(varIndex) + f * ((Double)parents.get(1).variables().get(varIndex) - (Double)parents.get(2).variables().get(varIndex));
            }
            case 1: {
                return (Double)parents.get(1).variables().get(varIndex) + f * ((Double)parents.get(2).variables().get(varIndex) - (Double)parents.get(3).variables().get(varIndex)) + f * ((Double)parents.get(4).variables().get(varIndex) - (Double)parents.get(4).variables().get(varIndex));
            }
            case 2: {
                return (Double)parents.get(0).variables().get(varIndex) + f * ((Double)parents.get(1).variables().get(varIndex) - (Double)parents.get(0).variables().get(varIndex)) + f * ((Double)parents.get(2).variables().get(varIndex) - (Double)parents.get(3).variables().get(varIndex));
            }
            case 3: 
            case 4: {
                return (Double)parents.get(0).variables().get(varIndex) + f * ((Double)parents.get(1).variables().get(varIndex) - (Double)parents.get(0).variables().get(varIndex)) + f * ((Double)parents.get(2).variables().get(varIndex) - (Double)parents.get(3).variables().get(varIndex));
            }
        }
        throw new UnsupportedOperationException("Variant not supported: " + String.valueOf((Object)this.variant));
    }

    private boolean shouldApplyCrossover(int varIndex, int totalVars, double cr, int jRand) {
        if (varIndex == jRand) {
            return true;
        }
        return this.randomGenerator.getRandomValue() < cr;
    }

    private double repairVariableValue(double value, DoubleSolution solution, int varIndex) {
        Bounds<Double> bounds = solution.getBounds(varIndex);
        return this.solutionRepair.repairSolutionVariableValue(value, bounds.getLowerBound(), bounds.getUpperBound());
    }

    private void updateArchive(DoubleSolution solution) {
        this.archive.add((DoubleSolution)solution.copy());
        int maxArchiveSize = (int)((double)this.populationSize * 2.0);
        while (this.archive.size() > maxArchiveSize) {
            this.archive.remove(0);
        }
    }

    private double nextGaussian(double mean, double stdDev) {
        double u1 = this.randomGenerator.getRandomValue();
        double u2 = this.randomGenerator.getRandomValue();
        return mean + stdDev * Math.sqrt(-2.0 * Math.log(u1)) * Math.cos(Math.PI * 2 * u2);
    }

    private double getCR() {
        if (this.variant == Variant.SHADE || this.variant == Variant.CURRENT_TO_PBEST_1) {
            double meanCR = this.memoryCR.get(this.memoryIndex);
            double randomizedCR = this.nextGaussian(meanCR, 0.1);
            return Math.max(0.0, Math.min(1.0, randomizedCR));
        }
        return this.cr;
    }

    private double getF() {
        if (this.variant == Variant.SHADE || this.variant == Variant.CURRENT_TO_PBEST_1) {
            double meanF = this.memoryF.get(this.memoryIndex);
            double randomizedF = this.nextGaussian(meanF, 0.1);
            return Math.max(0.1, Math.min(1.0, randomizedF));
        }
        return this.f;
    }

    private int getRank(DoubleSolution solution) {
        return 0;
    }

    @Override
    public int numberOfRequiredParents() {
        switch (this.variant.ordinal()) {
            case 0: 
            case 2: 
            case 3: {
                return 4;
            }
            case 1: {
                return 5;
            }
            case 4: {
                return 5;
            }
        }
        return 4;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 1;
    }

    @Override
    public double crossoverProbability() {
        return 1.0;
    }

    public static class Builder {
        private double cr = 0.5;
        private double f = 0.5;
        private Variant variant = Variant.RAND_1_BIN;
        private RandomGenerator<Double> randomGenerator = JMetalRandom.getInstance()::nextDouble;
        private int populationSize = 100;
        private double pBest = 0.1;
        private int memorySize = 5;

        public Builder withCr(double cr) {
            Check.valueIsNotNegative(cr);
            Check.that(cr <= 1.0, "CR must be less than or equal to 1.0");
            this.cr = cr;
            return this;
        }

        public Builder withF(double f) {
            Check.valueIsNotNegative(f);
            this.f = f;
            return this;
        }

        public Builder withVariant(Variant variant) {
            Check.notNull((Object)variant);
            this.variant = variant;
            return this;
        }

        public Builder withRandomGenerator(RandomGenerator<Double> randomGenerator) {
            Check.notNull(randomGenerator);
            this.randomGenerator = randomGenerator;
            return this;
        }

        public Builder withPopulationSize(int populationSize) {
            Check.that(populationSize >= 4, "Population size must be at least 4");
            this.populationSize = populationSize;
            return this;
        }

        public Builder withPBest(double pBest) {
            Check.valueIsInRange(pBest, 0.0, 1.0);
            this.pBest = pBest;
            return this;
        }

        public Builder withMemorySize(int memorySize) {
            Check.that(memorySize > 0, "Memory size must be greater than 0");
            this.memorySize = memorySize;
            return this;
        }

        public AdvancedDifferentialEvolutionCrossover build() {
            if (this.variant == Variant.SHADE || this.variant == Variant.CURRENT_TO_PBEST_1) {
                Check.that(this.populationSize >= 5, "Population size must be at least 5 for " + String.valueOf((Object)this.variant) + " variant");
            }
            return new AdvancedDifferentialEvolutionCrossover(this);
        }
    }

    public static enum Variant {
        RAND_1_BIN,
        RAND_2_BIN,
        CURRENT_TO_RAND_1,
        CURRENT_TO_PBEST_1,
        SHADE;

    }
}

