/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class LaplaceCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double DEFAULT_SCALE = 0.5;
    private final double scale;
    private final double crossoverProbability;
    private final RepairDoubleSolution solutionRepair;
    private final RandomGenerator<Double> randomGenerator;

    public LaplaceCrossover(double crossoverProbability) {
        this(crossoverProbability, 0.5, new RepairDoubleSolutionWithBoundValue());
    }

    public LaplaceCrossover(double crossoverProbability, double scale, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, scale, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public LaplaceCrossover(double crossoverProbability, double scale, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.that(scale > 0.0, "Scale parameter must be positive");
        Check.notNull(solutionRepair);
        Check.notNull(randomGenerator);
        this.crossoverProbability = crossoverProbability;
        this.scale = scale;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "There must be two parents instead of " + solutions.size());
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    private List<DoubleSolution> doCrossover(double probability, DoubleSolution parent1, DoubleSolution parent2) {
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        offspring.add((DoubleSolution)parent1.copy());
        offspring.add((DoubleSolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() <= probability) {
            for (int i = 0; i < parent1.variables().size(); ++i) {
                double x1 = (Double)parent1.variables().get(i);
                double x2 = (Double)parent2.variables().get(i);
                Bounds<Double> bounds = parent1.getBounds(i);
                double lowerBound = bounds.getLowerBound();
                double upperBound = bounds.getUpperBound();
                if (!(Math.abs(x1 - x2) > 1.0E-14)) continue;
                double beta = 0.0;
                double u = this.randomGenerator.getRandomValue();
                double r = this.randomGenerator.getRandomValue();
                beta = r <= 0.5 ? x1 - this.scale * Math.log(1.0 - u) : x1 + this.scale * Math.log(u);
                double y1 = beta;
                double y2 = x1 + x2 - beta;
                y1 = this.solutionRepair.repairSolutionVariableValue(y1, lowerBound, upperBound);
                y2 = this.solutionRepair.repairSolutionVariableValue(y2, lowerBound, upperBound);
                ((DoubleSolution)offspring.get(0)).variables().set(i, y1);
                ((DoubleSolution)offspring.get(1)).variables().set(i, y2);
            }
        }
        return offspring;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }

    public double getScale() {
        return this.scale;
    }
}

