/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class LevyFlightMutation
implements MutationOperator<DoubleSolution> {
    private double mutationProbability;
    private double beta;
    private double stepSize;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public LevyFlightMutation() {
        this(0.01, 1.5, 0.01);
    }

    public LevyFlightMutation(double mutationProbability, double beta, double stepSize) {
        this(mutationProbability, beta, stepSize, new RepairDoubleSolutionWithBoundValue());
    }

    public LevyFlightMutation(double mutationProbability, double beta, double stepSize, RepairDoubleSolution solutionRepair) {
        this(mutationProbability, beta, stepSize, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public LevyFlightMutation(double mutationProbability, double beta, double stepSize, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        if (mutationProbability < 0.0 || mutationProbability > 1.0) {
            throw new JMetalException("Mutation probability must be in [0, 1]");
        }
        if (beta <= 1.0 || beta > 2.0) {
            throw new JMetalException("Beta parameter must be in (1, 2]");
        }
        if (stepSize <= 0.0) {
            throw new JMetalException("Step size must be positive");
        }
        this.mutationProbability = mutationProbability;
        this.beta = beta;
        this.stepSize = stepSize;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        if (solution == null) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    private void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            if (!(this.randomGenerator.getRandomValue() <= probability)) continue;
            double currentValue = (Double)solution.variables().get(i);
            Bounds<Double> bounds = solution.getBounds(i);
            double lowerBound = bounds.getLowerBound();
            double upperBound = bounds.getUpperBound();
            double levyStep = this.generateLevyStep();
            double perturbation = levyStep * this.stepSize * (upperBound - lowerBound);
            double newValue = currentValue + perturbation;
            newValue = this.solutionRepair.repairSolutionVariableValue(newValue, lowerBound, upperBound);
            solution.variables().set(i, newValue);
        }
    }

    private double generateLevyStep() {
        double numerator = this.gamma(1.0 + this.beta) * Math.sin(Math.PI * this.beta / 2.0);
        double denominator = this.gamma((1.0 + this.beta) / 2.0) * this.beta * Math.pow(2.0, (this.beta - 1.0) / 2.0);
        double sigmaU = Math.pow(numerator / denominator, 1.0 / this.beta);
        double u = this.generateGaussian() * sigmaU;
        double v = this.generateGaussian();
        double levyStep = u / Math.pow(Math.abs(v), 1.0 / this.beta);
        return levyStep;
    }

    private double generateGaussian() {
        double u1 = this.randomGenerator.getRandomValue();
        double u2 = this.randomGenerator.getRandomValue();
        if (u1 < 1.0E-10) {
            u1 = 1.0E-10;
        }
        return Math.sqrt(-2.0 * Math.log(u1)) * Math.cos(Math.PI * 2 * u2);
    }

    private double gamma(double x) {
        if (x < 0.0) {
            throw new JMetalException("Gamma function not defined for negative values");
        }
        if (Math.abs(x - 1.0) < 1.0E-10) {
            return 1.0;
        }
        if (Math.abs(x - 2.0) < 1.0E-10) {
            return 1.0;
        }
        if (Math.abs(x - 0.5) < 1.0E-10) {
            return Math.sqrt(Math.PI);
        }
        if (Math.abs(x - 1.5) < 1.0E-10) {
            return 0.5 * Math.sqrt(Math.PI);
        }
        if (x > 1.0) {
            return Math.sqrt(Math.PI * 2 / x) * Math.pow(x / Math.E, x);
        }
        return this.gamma(x + 1.0) / x;
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    public void mutationProbability(double mutationProbability) {
        if (mutationProbability < 0.0 || mutationProbability > 1.0) {
            throw new JMetalException("Mutation probability must be in [0, 1]");
        }
        this.mutationProbability = mutationProbability;
    }

    public double beta() {
        return this.beta;
    }

    public void beta(double beta) {
        if (beta <= 1.0 || beta > 2.0) {
            throw new JMetalException("Beta parameter must be in (1, 2]");
        }
        this.beta = beta;
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize(double stepSize) {
        if (stepSize <= 0.0) {
            throw new JMetalException("Step size must be positive");
        }
        this.stepSize = stepSize;
    }

    public RepairDoubleSolution solutionRepair() {
        return this.solutionRepair;
    }

    public void solutionRepair(RepairDoubleSolution solutionRepair) {
        this.solutionRepair = solutionRepair;
    }

    public String toString() {
        return "LevyFlightMutation{mutationProbability=" + this.mutationProbability + ", beta=" + this.beta + ", stepSize=" + this.stepSize + "}";
    }
}

