/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class NonUniformMutation
implements MutationOperator<DoubleSolution> {
    private double perturbation;
    private int maxIterations;
    private double mutationProbability;
    private int currentIteration;
    private RandomGenerator<Double> randomGenenerator;
    private RepairDoubleSolution solutionRepair;

    public NonUniformMutation(double mutationProbability, double perturbation, int maxIterations) {
        this(mutationProbability, perturbation, maxIterations, new RepairDoubleSolutionWithBoundValue(), () -> JMetalRandom.getInstance().nextDouble());
    }

    public NonUniformMutation(double mutationProbability, double perturbation, int maxIterations, RepairDoubleSolution solutionRepair) {
        this(mutationProbability, perturbation, maxIterations, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public NonUniformMutation(double mutationProbability, double perturbation, int maxIterations, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenenerator) {
        this.perturbation = perturbation;
        this.mutationProbability = mutationProbability;
        this.maxIterations = maxIterations;
        this.solutionRepair = solutionRepair;
        this.randomGenenerator = randomGenenerator;
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        Check.that(currentIteration >= 0, "The iteration number cannot be a negative value: " + currentIteration);
        this.currentIteration = currentIteration;
    }

    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        Check.notNull(solution);
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            if (!(this.randomGenenerator.getRandomValue() < probability)) continue;
            double rand = this.randomGenenerator.getRandomValue();
            Bounds<Double> bounds = solution.getBounds(i);
            double tmp = rand <= 0.5 ? this.delta(bounds.getUpperBound() - (Double)solution.variables().get(i), this.perturbation) : this.delta(bounds.getLowerBound() - (Double)solution.variables().get(i), this.perturbation);
            tmp += ((Double)solution.variables().get(i)).doubleValue();
            tmp = this.solutionRepair.repairSolutionVariableValue(tmp, bounds.getLowerBound(), bounds.getUpperBound());
            solution.variables().set(i, tmp);
        }
    }

    private double delta(double y, double bMutationParameter) {
        double rand = this.randomGenenerator.getRandomValue();
        int it = this.currentIteration;
        int maxIt = this.maxIterations;
        return y * (1.0 - Math.pow(rand, Math.pow(1.0 - (double)it / (double)maxIt, bMutationParameter)));
    }
}

