/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class PowerLawMutation
implements MutationOperator<DoubleSolution> {
    private double mutationProbability;
    private double delta;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public PowerLawMutation() {
        this(0.01, 1.0);
    }

    public PowerLawMutation(double mutationProbability, double delta) {
        this(mutationProbability, delta, new RepairDoubleSolutionWithBoundValue());
    }

    public PowerLawMutation(double mutationProbability, double delta, RepairDoubleSolution solutionRepair) {
        this(mutationProbability, delta, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public PowerLawMutation(double mutationProbability, double delta, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        if (mutationProbability < 0.0 || mutationProbability > 1.0) {
            throw new JMetalException("Mutation probability must be in [0, 1]");
        }
        if (delta <= 0.0) {
            throw new JMetalException("Delta parameter must be positive");
        }
        this.mutationProbability = mutationProbability;
        this.delta = delta;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        if (solution == null) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    private void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            if (!(this.randomGenerator.getRandomValue() <= probability)) continue;
            double currentValue = (Double)solution.variables().get(i);
            Bounds<Double> bounds = solution.getBounds(i);
            double lowerBound = bounds.getLowerBound();
            double upperBound = bounds.getUpperBound();
            double rnd = this.randomGenerator.getRandomValue();
            if (rnd < 1.0E-10) {
                rnd = 1.0E-10;
            } else if (rnd > 0.9999999999) {
                rnd = 0.9999999999;
            }
            double tempDelta = Math.pow(rnd, -this.delta);
            double deltaq = 0.5 * (rnd - 0.5) * (1.0 - tempDelta);
            double newValue = currentValue + deltaq * (upperBound - lowerBound);
            newValue = this.solutionRepair.repairSolutionVariableValue(newValue, lowerBound, upperBound);
            solution.variables().set(i, newValue);
        }
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    public void mutationProbability(double mutationProbability) {
        if (mutationProbability < 0.0 || mutationProbability > 1.0) {
            throw new JMetalException("Mutation probability must be in [0, 1]");
        }
        this.mutationProbability = mutationProbability;
    }

    public double delta() {
        return this.delta;
    }

    public void delta(double delta) {
        if (delta <= 0.0) {
            throw new JMetalException("Delta parameter must be positive");
        }
        this.delta = delta;
    }

    public RepairDoubleSolution solutionRepair() {
        return this.solutionRepair;
    }

    public void solutionRepair(RepairDoubleSolution solutionRepair) {
        this.solutionRepair = solutionRepair;
    }

    public String toString() {
        return "PowerLawMutation{mutationProbability=" + this.mutationProbability + ", delta=" + this.delta + "}";
    }
}

