/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import java.util.Collections;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SimpleInversionMutation<T>
implements MutationOperator<PermutationSolution<T>> {
    private final double mutationProbability;
    private final JMetalRandom randomNumberGenerator = JMetalRandom.getInstance();

    public SimpleInversionMutation(double mutationProbability) {
        Check.probabilityIsValid(mutationProbability);
        this.mutationProbability = mutationProbability;
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    @Override
    public PermutationSolution<T> execute(PermutationSolution<T> solution) {
        Check.notNull(solution);
        this.doMutation(solution);
        return solution;
    }

    public void doMutation(PermutationSolution<T> solution) {
        if (this.randomNumberGenerator.nextDouble() < this.mutationProbability) {
            Collections.reverse(solution.variables());
        }
    }
}

