/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.Arrays;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.comparator.LexicographicalVectorComparator;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenVectors;

public class Spread
extends QualityIndicator {
    public Spread() {
    }

    public Spread(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public QualityIndicator newInstance() {
        return new Spread();
    }

    @Override
    public double compute(double[][] front) {
        return this.spread(front, this.referenceFront);
    }

    public double spread(double[][] front, double[][] referenceFront) {
        int i;
        EuclideanDistanceBetweenVectors distance = new EuclideanDistanceBetweenVectors();
        Arrays.sort(front, 0, front.length, new LexicographicalVectorComparator());
        Arrays.sort(referenceFront, 0, referenceFront.length, new LexicographicalVectorComparator());
        double df = distance.compute(front[0], referenceFront[0]);
        double dl = distance.compute(front[front.length - 1], referenceFront[referenceFront.length - 1]);
        double mean = 0.0;
        double diversitySum = df + dl;
        int numberOfPoints = front.length;
        for (i = 0; i < numberOfPoints - 1; ++i) {
            mean += distance.compute(front[i], front[i + 1]);
        }
        mean /= (double)(numberOfPoints - 1);
        if (numberOfPoints > 1) {
            for (i = 0; i < numberOfPoints - 1; ++i) {
                diversitySum += Math.abs(distance.compute(front[i], front[i + 1]) - mean);
            }
            return diversitySum / (df + dl + (double)(numberOfPoints - 1) * mean);
        }
        return 1.0;
    }

    @Override
    public String name() {
        return "SP";
    }

    @Override
    public String description() {
        return "Spread quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

