/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.doublesolution.impl;

import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultDoubleSolution
extends AbstractSolution<Double>
implements DoubleSolution {
    protected List<Bounds<Double>> bounds;

    public DefaultDoubleSolution(List<Bounds<Double>> boundsList, int numberOfObjectives, int numberOfConstraints) {
        super(boundsList.size(), numberOfObjectives, numberOfConstraints);
        this.bounds = boundsList;
        for (int i = 0; i < boundsList.size(); ++i) {
            this.variables().set(i, JMetalRandom.getInstance().nextDouble(this.bounds.get(i).getLowerBound(), this.bounds.get(i).getUpperBound()));
        }
    }

    public DefaultDoubleSolution(DefaultDoubleSolution solution) {
        super(solution.variables().size(), solution.objectives().length, solution.constraints().length);
        IntStream.range(0, solution.variables().size()).forEach(i -> this.variables().set(i, (Double)solution.variables().get(i)));
        IntStream.range(0, solution.objectives().length).forEach(i -> {
            this.objectives()[i] = solution.objectives()[i];
        });
        IntStream.range(0, solution.constraints().length).forEach(i -> {
            this.constraints()[i] = solution.constraints()[i];
        });
        this.bounds = solution.bounds;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Bounds<Double> getBounds(int index) {
        return this.bounds.get(index);
    }

    public DefaultDoubleSolution copy() {
        return new DefaultDoubleSolution(this);
    }
}

