/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.integersolution.impl;

import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultIntegerSolution
extends AbstractSolution<Integer>
implements IntegerSolution {
    protected List<Bounds<Integer>> bounds;

    public DefaultIntegerSolution(List<Bounds<Integer>> boundsList, int numberOfObjectives, int numberOfConstraints) {
        super(boundsList.size(), numberOfObjectives, numberOfConstraints);
        this.bounds = boundsList;
        IntStream.range(0, this.bounds.size()).forEach(i -> this.variables().set(i, JMetalRandom.getInstance().nextInt(this.bounds.get(i).getLowerBound(), this.bounds.get(i).getUpperBound())));
    }

    public DefaultIntegerSolution(DefaultIntegerSolution solution) {
        super(solution.variables().size(), solution.objectives().length, solution.constraints().length);
        IntStream.range(0, solution.variables().size()).forEach(i -> this.variables().set(i, (Integer)solution.variables().get(i)));
        IntStream.range(0, solution.objectives().length).forEach(i -> {
            this.objectives()[i] = solution.objectives()[i];
        });
        IntStream.range(0, solution.constraints().length).forEach(i -> {
            this.constraints()[i] = solution.constraints()[i];
        });
        this.bounds = solution.bounds;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Bounds<Integer> getBounds(int index) {
        return this.bounds.get(index);
    }

    public DefaultIntegerSolution copy() {
        return new DefaultIntegerSolution(this);
    }
}

