/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.aggregationfunction.impl;

import org.uma.jmetal.util.aggregationfunction.AggregationFunction;
import org.uma.jmetal.util.point.impl.IdealPoint;
import org.uma.jmetal.util.point.impl.NadirPoint;

public class ModifiedTschebyscheff
implements AggregationFunction {
    private boolean normalizeObjectives;
    private double epsilon = 1.0E-6;

    public ModifiedTschebyscheff(boolean normalizeObjectives) {
        this.normalizeObjectives = normalizeObjectives;
    }

    @Override
    public double compute(double[] vector, double[] weightVector, IdealPoint idealPoint, NadirPoint nadirPoint) {
        double maxFun = -1.0E30;
        for (int n = 0; n < vector.length; ++n) {
            double diff = this.normalizeObjectives ? Math.abs((vector[n] - idealPoint.value(n)) / (nadirPoint.value(n) - idealPoint.value(n) + this.epsilon)) : Math.abs(vector[n] - idealPoint.value(n));
            double feval = weightVector[n] == 0.0 ? 1.0E-7 * diff : diff / weightVector[n];
            if (!(feval > maxFun)) continue;
            maxFun = feval;
        }
        return maxFun;
    }

    @Override
    public void epsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean normalizeObjectives() {
        return this.normalizeObjectives;
    }
}

