/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.bounds;

import java.io.Serializable;

public interface Bounds<T extends Comparable<T>>
extends Serializable {
    public T getLowerBound();

    public T getUpperBound();

    default public T restrict(T value) {
        T lowerBound = this.getLowerBound();
        if (lowerBound.compareTo(value) > 0) {
            return lowerBound;
        }
        T upperBound = this.getUpperBound();
        if (upperBound.compareTo(value) < 0) {
            return upperBound;
        }
        return value;
    }

    public static <T extends Comparable<T>> Bounds<T> create(final T lowerBound, final T upperBound) {
        if (lowerBound == null) {
            throw new IllegalArgumentException("null lower bound");
        }
        if (upperBound == null) {
            throw new IllegalArgumentException("null upper bound");
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException(String.format("lower bound (%s) must be below upper bound (%s)", lowerBound, upperBound));
        }
        return new Bounds<T>(){

            @Override
            public T getLowerBound() {
                return lowerBound;
            }

            @Override
            public T getUpperBound() {
                return upperBound;
            }
        };
    }
}

