/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.KNearestDistanceCalculator;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.errorchecking.Check;

public class KnnDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private final String attributeId = this.getClass().getName();
    private final KNearestDistanceCalculator kNearestDistanceCalculator;
    private final int k;

    public KnnDensityEstimator(int k) {
        this(k, false);
    }

    public KnnDensityEstimator(int k, boolean normalize) {
        this.k = k;
        this.kNearestDistanceCalculator = new KNearestDistanceCalculator(k, normalize);
    }

    @Override
    public void compute(List<S> solutionList) {
        int size = solutionList.size();
        Check.that(size > 0, "The solution list size must be greater than zero");
        if (size <= this.k) {
            return;
        }
        double[][] distanceMatrix = SolutionListUtils.getMatrixWithObjectiveValues(solutionList);
        double[] distances = this.kNearestDistanceCalculator.compute(distanceMatrix);
        for (int i = 0; i < solutionList.size(); ++i) {
            ((Solution)solutionList.get(i)).attributes().put(this.attributeId, distances[i]);
        }
    }

    @Override
    public Double value(S solution) {
        Check.notNull(solution);
        Double result = 0.0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Double)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Comparator<S> comparator() {
        return Comparator.comparing(this::value);
    }
}

