/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.measure.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.PullMeasure;
import org.uma.jmetal.util.measure.PushMeasure;
import org.uma.jmetal.util.measure.impl.SimplePullMeasure;

public class ListenerTimeMeasure
extends SimplePullMeasure<Long>
implements PullMeasure<Long> {
    private Long lastReset = 0L;
    private Long time = 0L;
    private final WeakHashMap<PushMeasure<?>, PushMeasure<?>> measureCache = new WeakHashMap();
    private final WeakHashMap<MeasureListener<?>, MeasureListener<?>> listenerCache = new WeakHashMap();

    public <Value> MeasureListener<Value> wrapListener(final MeasureListener<Value> wrapped) {
        if (wrapped == null) {
            throw new IllegalArgumentException("No listener provided");
        }
        MeasureListener wrapper = this.listenerCache.get(wrapped);
        if (wrapper == null) {
            wrapper = new MeasureListener<Value>(){
                final /* synthetic */ ListenerTimeMeasure this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void measureGenerated(Value value) {
                    long start = System.currentTimeMillis();
                    wrapped.measureGenerated(value);
                    long stop = System.currentTimeMillis();
                    this.this$0.time = this.this$0.time + (stop - Math.max(start, this.this$0.lastReset));
                }
            };
            this.listenerCache.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public <Value> PushMeasure<Value> wrapMeasure(final PushMeasure<Value> wrapped) {
        if (wrapped == null) {
            throw new IllegalArgumentException("No measure provided");
        }
        PushMeasure wrapper = this.measureCache.get(wrapped);
        if (wrapper == null) {
            wrapper = new PushMeasure<Value>(){
                final /* synthetic */ ListenerTimeMeasure this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String name() {
                    return wrapped.name();
                }

                @Override
                public String description() {
                    return wrapped.description();
                }

                @Override
                public void register(MeasureListener<Value> listener) {
                    wrapped.register(this.this$0.wrapListener(listener));
                }

                @Override
                public void unregister(MeasureListener<Value> listener) {
                    wrapped.unregister(this.this$0.wrapListener(listener));
                }
            };
            this.measureCache.put(wrapped, wrapper);
        }
        return wrapper;
    }

    public <Value> MeasureManager wrapManager(final MeasureManager wrapped, final Object measureKey) {
        if (wrapped == null) {
            throw new IllegalArgumentException("No manager provided");
        }
        if (measureKey != null && wrapped.getMeasureKeys().contains(measureKey)) {
            throw new IllegalArgumentException("The key " + String.valueOf(measureKey) + " is already used by the wrapped manager " + String.valueOf(wrapped));
        }
        MeasureManager wrapper = measureKey != null ? new MeasureManager(){
            final /* synthetic */ ListenerTimeMeasure this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public <T> PushMeasure<T> getPushMeasure(Object key) {
                return this.this$0.wrapMeasure(wrapped.getPushMeasure(key));
            }

            @Override
            public <T> PullMeasure<T> getPullMeasure(Object key) {
                if (key.equals(measureKey)) {
                    return this.this$0;
                }
                return wrapped.getPullMeasure(key);
            }

            @Override
            public Collection<Object> getMeasureKeys() {
                LinkedList<Object> keys = new LinkedList<Object>(wrapped.getMeasureKeys());
                keys.add(measureKey);
                return keys;
            }
        } : new MeasureManager(){
            final /* synthetic */ ListenerTimeMeasure this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public <T> PushMeasure<T> getPushMeasure(Object key) {
                return this.this$0.wrapMeasure(wrapped.getPushMeasure(key));
            }

            @Override
            public <T> PullMeasure<T> getPullMeasure(Object key) {
                return wrapped.getPullMeasure(key);
            }

            @Override
            public Collection<Object> getMeasureKeys() {
                return wrapped.getMeasureKeys();
            }
        };
        return wrapper;
    }

    @Override
    public Long get() {
        return this.time;
    }

    public void reset() {
        this.time = 0L;
        this.lastReset = System.currentTimeMillis();
    }
}

