/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;

public class WriteSolutionsToFilesObserver
implements Observer<Map<String, Object>> {
    private Integer frequency;
    private int counter;
    private String outputDirectory = "";

    public WriteSolutionsToFilesObserver(Integer frequency, String outputDirectory) {
        this.frequency = frequency;
        this.counter = 0;
        this.outputDirectory = outputDirectory;
        File file = new File(outputDirectory);
        if (file.exists()) {
            if (file.isFile()) {
                throw new RuntimeException(outputDirectory + " exists and it is a file");
            }
            if (file.isDirectory()) {
                throw new RuntimeException(outputDirectory + " exists and it is a directory");
            }
        } else if (!file.mkdir()) {
            throw new RuntimeException("Unable to create the directory");
        }
    }

    public WriteSolutionsToFilesObserver() {
        this(1, "outputDirectory");
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        List population = (List)data.get("POPULATION");
        if (population != null) {
            if (this.counter % this.frequency == 0) {
                new SolutionListOutput(population).setVarFileOutputContext(new DefaultFileOutputContext(this.outputDirectory + "/VAR." + this.counter + ".tsv")).setFunFileOutputContext(new DefaultFileOutputContext(this.outputDirectory + "/FUN." + this.counter + ".tsv")).print();
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + ": The POPULATION is null");
        }
        ++this.counter;
    }

    public String getName() {
        return "Print objectives observer";
    }

    public String toString() {
        return this.getName();
    }
}

