/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.ranking.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.ranking.Ranking;
import org.uma.jmetal.util.ranking.impl.util.MNDSBitsetManager;

public class MergeNonDominatedSortRanking<S extends Solution<?>>
implements Ranking<S> {
    private final String attributeId = this.getClass().getName();
    private static final int INSERTIONSORT = 7;
    private int SOL_ID;
    private int SORT_INDEX;
    private int m;
    private int n;
    private int initialPopulationSize;
    private int[] ranking;
    private double[][] population;
    private double[][] work;
    private ArrayList<int[]> duplicatedSolutions;
    private MNDSBitsetManager bsManager;
    private List<ArrayList<S>> rankedSubPopulations;

    @Override
    public Ranking<S> compute(List<S> solutionSet) {
        this.initialPopulationSize = solutionSet.size();
        this.n = solutionSet.size();
        this.m = ((Solution)solutionSet.get(0)).objectives().length;
        this.bsManager = new MNDSBitsetManager(this.n);
        this.SOL_ID = this.m;
        this.SORT_INDEX = this.SOL_ID + 1;
        this.work = new double[this.n][this.SORT_INDEX + 1];
        this.population = new double[this.n][this.SORT_INDEX + 1];
        for (int i = 0; i < this.n; ++i) {
            this.population[i] = new double[this.SORT_INDEX + 1];
            System.arraycopy(((Solution)solutionSet.get(i)).objectives(), 0, this.population[i], 0, this.m);
            this.population[i][this.SOL_ID] = i;
        }
        int[] ranking = this.sort(this.population);
        this.rankedSubPopulations = new ArrayList<ArrayList<S>>();
        for (int i = 0; i < this.n; ++i) {
            for (int r = this.rankedSubPopulations.size(); r <= ranking[i]; ++r) {
                this.rankedSubPopulations.add(new ArrayList());
            }
            ((Solution)solutionSet.get(i)).attributes().put(this.attributeId, ranking[i]);
            this.rankedSubPopulations.get(ranking[i]).add((Solution)solutionSet.get(i));
        }
        return this;
    }

    private int compareLex(double[] s1, double[] s2, int fromObj, int toObj) {
        while (fromObj < toObj) {
            if (s1[fromObj] < s2[fromObj]) {
                return -1;
            }
            if (s1[fromObj] > s2[fromObj]) {
                return 1;
            }
            ++fromObj;
        }
        return 0;
    }

    private boolean mergeSort(double[][] src, double[][] dest, int low, int high, int obj, int toObj) {
        double[] temp = null;
        int destLow = low;
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && this.compareLex(dest[j - 1], dest[j], obj, toObj) > 0; --j) {
                    temp = dest[j];
                    dest[j] = dest[j - 1];
                    dest[j - 1] = temp;
                }
            }
            return temp == null;
        }
        int mid = low + high >>> 1;
        boolean isSorted = this.mergeSort(dest, src, low, mid, obj, toObj);
        isSorted &= this.mergeSort(dest, src, mid, high, obj, toObj);
        if (src[mid - 1][obj] <= src[mid][obj]) {
            System.arraycopy(src, low, dest, destLow, length);
            return isSorted;
        }
        int i = low;
        int j = mid;
        for (int s = low; s < high; ++s) {
            dest[s] = j >= high ? src[i++] : (i < mid && this.compareLex(src[i], src[j], obj, toObj) <= 0 ? src[i++] : src[j++]);
        }
        return false;
    }

    private boolean sortFirstObjective() {
        int p = 0;
        System.arraycopy(this.population, 0, this.work, 0, this.n);
        this.mergeSort(this.population, this.work, 0, this.n, 0, this.m);
        this.population[0] = this.work[0];
        this.population[0][this.SORT_INDEX] = 0.0;
        for (int q = 1; q < this.n; ++q) {
            if (0 != this.compareLex(this.population[p], this.work[q], 0, this.m)) {
                this.population[++p] = this.work[q];
                this.population[p][this.SORT_INDEX] = p;
                continue;
            }
            this.duplicatedSolutions.add(new int[]{(int)this.population[p][this.SOL_ID], (int)this.work[q][this.SOL_ID]});
        }
        this.n = p + 1;
        return this.n > 1;
    }

    private boolean sortSecondObjective() {
        boolean dominance = false;
        System.arraycopy(this.population, 0, this.work, 0, this.n);
        this.mergeSort(this.population, this.work, 0, this.n, 1, 2);
        System.arraycopy(this.work, 0, this.population, 0, this.n);
        for (int p = 0; p < this.n; ++p) {
            int solutionId = (int)this.population[p][this.SORT_INDEX];
            dominance |= this.bsManager.initializeSolutionBitset(solutionId);
            this.bsManager.updateIncrementalBitset(solutionId);
            if (2 != this.m) continue;
            int initSolId = (int)this.population[p][this.SOL_ID];
            this.bsManager.computeSolutionRanking(solutionId, initSolId);
        }
        return dominance;
    }

    private void sortRestOfObjectives() {
        int lastObjective = this.m - 1;
        System.arraycopy(this.population, 0, this.work, 0, this.n);
        for (int obj = 2; obj < this.m; ++obj) {
            int p;
            if (this.mergeSort(this.population, this.work, 0, this.n, obj, obj + 1)) {
                if (obj != lastObjective) continue;
                for (p = 0; p < this.n; ++p) {
                    this.bsManager.computeSolutionRanking((int)this.population[p][this.SORT_INDEX], (int)this.population[p][this.SOL_ID]);
                }
                continue;
            }
            System.arraycopy(this.work, 0, this.population, 0, this.n);
            this.bsManager.clearIncrementalBitset();
            boolean dominance = false;
            for (p = 0; p < this.n; ++p) {
                int initSolId = (int)this.population[p][this.SOL_ID];
                int solutionId = (int)this.population[p][this.SORT_INDEX];
                if (obj < lastObjective) {
                    dominance |= this.bsManager.updateSolutionDominance(solutionId);
                } else {
                    this.bsManager.computeSolutionRanking(solutionId, initSolId);
                }
                this.bsManager.updateIncrementalBitset(solutionId);
            }
            if (dominance) continue;
            return;
        }
    }

    public final int[] sort(double[][] populationData) {
        this.population = populationData;
        this.duplicatedSolutions = new ArrayList(this.n);
        if (this.sortFirstObjective() && this.sortSecondObjective()) {
            this.sortRestOfObjectives();
        }
        this.ranking = this.bsManager.getRanking();
        for (int[] duplicated : this.duplicatedSolutions) {
            this.ranking[duplicated[1]] = this.ranking[duplicated[0]];
        }
        this.n = this.initialPopulationSize;
        return this.ranking;
    }

    @Override
    public List<S> getSubFront(int rank) {
        if (rank >= this.rankedSubPopulations.size()) {
            throw new JMetalException("Invalid rank: " + rank + ". Max rank = " + (this.rankedSubPopulations.size() - 1));
        }
        return this.rankedSubPopulations.get(rank);
    }

    @Override
    public int getNumberOfSubFronts() {
        return this.rankedSubPopulations.size();
    }

    @Override
    public Integer getRank(S solution) {
        Check.notNull(solution);
        Integer result = -1;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Integer)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Object getAttributedId() {
        return this.attributeId;
    }
}

