package org.uma.jmetal.util.measure;

/**
 * A {@link MeasureListener} allows to register a given behavior to
 * {@link PushMeasure#register(MeasureListener)}. When the {@link PushMeasure}
 * generate a {@link Value}, it is provided to
 * {@link MeasureListener#measureGenerated(Object)} in order to execute the
 * specified behavior.
 * 
 * @author Created by Antonio J. Nebro on 21/10/14 based on the ideas of
 *         Matthieu Vergne 
 * 
 * @param <Value>
 */
public interface MeasureListener<Value> {
	/**
	 * 
	 * @param value
	 *            the {@link Value} generated by the {@link PushMeasure}
	 */
	public void measureGenerated(Value value);
}
