/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;

public abstract class AbstractScatterSearch<S, R>
implements Algorithm<R> {
    private List<S> population;
    private int populationSize;

    public List<S> getPopulation() {
        return this.population;
    }

    public void setPopulation(List<S> population) {
        this.population = population;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public abstract boolean isStoppingConditionReached();

    public abstract boolean restartConditionIsFulfilled(List<S> var1);

    public abstract void restart();

    public abstract S diversificationGeneration();

    public abstract S improvement(S var1);

    public abstract void referenceSetUpdate();

    public abstract void referenceSetUpdate(S var1);

    public abstract List<List<S>> subsetGeneration();

    public abstract List<S> solutionCombination(List<List<S>> var1);

    @Override
    public abstract R result();

    @Override
    public void run() {
        this.initializationPhase();
        this.referenceSetUpdate();
        while (!this.isStoppingConditionReached()) {
            List<List<S>> subset = this.subsetGeneration();
            List<S> combinedSolutions = this.solutionCombination(subset);
            if (this.restartConditionIsFulfilled(combinedSolutions)) {
                this.restart();
                this.referenceSetUpdate();
                continue;
            }
            for (S solution : combinedSolutions) {
                S improvedSolution = this.improvement(solution);
                this.referenceSetUpdate(improvedSolution);
            }
        }
    }

    public void initializationPhase() {
        this.population = new ArrayList<S>(this.populationSize);
        while (this.population.size() < this.populationSize) {
            S newSolution = this.diversificationGeneration();
            S improvedSolution = this.improvement(newSolution);
            this.population.add(improvedSolution);
        }
    }
}

