/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class ArithmeticCrossover
implements CrossoverOperator<DoubleSolution> {
    private final double crossoverProbability;
    private final RepairDoubleSolution solutionRepair;
    private final RandomGenerator<Double> randomGenerator;

    public ArithmeticCrossover(double crossoverProbability) {
        this(crossoverProbability, new RepairDoubleSolutionWithBoundValue());
    }

    public ArithmeticCrossover(double crossoverProbability, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public ArithmeticCrossover(double crossoverProbability, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.notNull(solutionRepair);
        Check.notNull(randomGenerator);
        this.crossoverProbability = crossoverProbability;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "Arithmetic Crossover requires exactly two parents");
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        DoubleSolution parent1 = solutions.get(0);
        DoubleSolution parent2 = solutions.get(1);
        DoubleSolution child1 = (DoubleSolution)parent1.copy();
        DoubleSolution child2 = (DoubleSolution)parent2.copy();
        if (this.randomGenerator.getRandomValue() < this.crossoverProbability) {
            int numberOfVariables = parent1.variables().size();
            for (int i = 0; i < numberOfVariables; ++i) {
                double p1 = (Double)parent1.variables().get(i);
                double p2 = (Double)parent2.variables().get(i);
                double alpha = this.randomGenerator.getRandomValue();
                double value1 = alpha * p1 + (1.0 - alpha) * p2;
                double value2 = (1.0 - alpha) * p1 + alpha * p2;
                double lowerBound = child1.getBounds(i).getLowerBound();
                double upperBound = child1.getBounds(i).getUpperBound();
                child1.variables().set(i, this.solutionRepair.repairSolutionVariableValue(value1, lowerBound, upperBound));
                child2.variables().set(i, this.solutionRepair.repairSolutionVariableValue(value2, lowerBound, upperBound));
            }
        }
        offspring.add(child1);
        offspring.add(child2);
        return offspring;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

