/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class EdgeRecombinationCrossover
implements CrossoverOperator<PermutationSolution<Integer>> {
    private final double probability;
    private final JMetalRandom randomNumberGenerator = JMetalRandom.getInstance();

    public EdgeRecombinationCrossover(double probability) {
        Check.probabilityIsValid(probability);
        this.probability = probability;
    }

    @Override
    public List<PermutationSolution<Integer>> execute(List<PermutationSolution<Integer>> solutions) {
        if (solutions.size() != 2) {
            throw new JMetalException("EdgeRecombinationCrossover requires exactly two parents.");
        }
        PermutationSolution<Integer> parent1 = solutions.get(0);
        PermutationSolution<Integer> parent2 = solutions.get(1);
        ArrayList<PermutationSolution<Integer>> offspring = new ArrayList<PermutationSolution<Integer>>(2);
        offspring.add((PermutationSolution)parent1.copy());
        offspring.add((PermutationSolution)parent2.copy());
        if (this.randomNumberGenerator.nextDouble() < this.probability) {
            List<Integer> child1 = this.edgeRecombination(parent1.variables(), parent2.variables());
            List<Integer> child2 = this.edgeRecombination(parent2.variables(), parent1.variables());
            for (int i = 0; i < child1.size(); ++i) {
                ((PermutationSolution)offspring.get(0)).variables().set(i, child1.get(i));
                ((PermutationSolution)offspring.get(1)).variables().set(i, child2.get(i));
            }
        }
        return offspring;
    }

    private List<Integer> edgeRecombination(List<Integer> parent1, List<Integer> parent2) {
        int value;
        int i;
        HashMap edgeMap = new HashMap();
        for (i = 0; i < parent1.size(); ++i) {
            value = parent1.get(i);
            edgeMap.putIfAbsent(value, new HashSet());
            ((Set)edgeMap.get(value)).add(parent1.get((i + 1) % parent1.size()));
            ((Set)edgeMap.get(value)).add(parent1.get((i - 1 + parent1.size()) % parent1.size()));
        }
        for (i = 0; i < parent2.size(); ++i) {
            value = parent2.get(i);
            edgeMap.putIfAbsent(value, new HashSet());
            ((Set)edgeMap.get(value)).add(parent2.get((i + 1) % parent2.size()));
            ((Set)edgeMap.get(value)).add(parent2.get((i - 1 + parent2.size()) % parent2.size()));
        }
        ArrayList<Integer> child = new ArrayList<Integer>();
        Integer current = parent1.get(0);
        while (child.size() < parent1.size()) {
            child.add(current);
            ArrayList neighbors = new ArrayList((Collection)edgeMap.get(current));
            neighbors.removeAll(child);
            if (neighbors.isEmpty()) {
                for (Integer value2 : edgeMap.keySet()) {
                    if (child.contains(value2)) continue;
                    current = value2;
                    break;
                }
            } else {
                ArrayList<Integer> minNeighbors = new ArrayList<Integer>();
                int minSize = Integer.MAX_VALUE;
                for (Integer neighbor : neighbors) {
                    int neighborSize = ((Set)edgeMap.get(neighbor)).size();
                    if (neighborSize < minSize) {
                        minNeighbors.clear();
                        minNeighbors.add(neighbor);
                        minSize = neighborSize;
                        continue;
                    }
                    if (neighborSize != minSize) continue;
                    minNeighbors.add(neighbor);
                }
                current = (Integer)minNeighbors.get(this.randomNumberGenerator.nextInt(0, minNeighbors.size() - 1));
            }
            for (Set adjacencyList : edgeMap.values()) {
                adjacencyList.remove(current);
            }
        }
        return child;
    }

    @Override
    public double crossoverProbability() {
        return this.probability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

