/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class OXDCrossover
implements CrossoverOperator<PermutationSolution<Integer>> {
    private final double probability;
    private final JMetalRandom randomNumberGenerator = JMetalRandom.getInstance();

    public OXDCrossover(double probability) {
        Check.probabilityIsValid(probability);
        this.probability = probability;
    }

    @Override
    public List<PermutationSolution<Integer>> execute(List<PermutationSolution<Integer>> solutions) {
        Check.notNull(solutions);
        Check.collectionIsNotEmpty(solutions);
        if (solutions.size() != 2) {
            throw new JMetalException("OXDCrossover requires exactly two parents.");
        }
        PermutationSolution<Integer> parent1 = solutions.get(0);
        PermutationSolution<Integer> parent2 = solutions.get(1);
        Check.notNull(parent1);
        Check.notNull(parent2);
        int permutationLength = parent1.variables().size();
        ArrayList<PermutationSolution<Integer>> offspring = new ArrayList<PermutationSolution<Integer>>(2);
        offspring.add((PermutationSolution)parent1.copy());
        offspring.add((PermutationSolution)parent2.copy());
        if (this.randomNumberGenerator.nextDouble() < this.probability) {
            int cuttingPoint1 = this.randomNumberGenerator.nextInt(0, permutationLength - 2);
            int cuttingPoint2 = this.randomNumberGenerator.nextInt(cuttingPoint1 + 1, permutationLength - 1);
            for (int i = cuttingPoint1; i <= cuttingPoint2; ++i) {
                ((PermutationSolution)offspring.get(0)).variables().set(i, (Integer)parent2.variables().get(i));
                ((PermutationSolution)offspring.get(1)).variables().set(i, (Integer)parent1.variables().get(i));
            }
            this.repairOffspring((PermutationSolution)offspring.get(0), parent1, parent2, cuttingPoint1, cuttingPoint2);
            this.repairOffspring((PermutationSolution)offspring.get(1), parent2, parent1, cuttingPoint1, cuttingPoint2);
        }
        return offspring;
    }

    private void repairOffspring(PermutationSolution<Integer> offspring, PermutationSolution<Integer> parent, PermutationSolution<Integer> otherParent, int cuttingPoint1, int cuttingPoint2) {
        int permutationLength = offspring.variables().size();
        HashSet genesInSegment = new HashSet(offspring.variables().subList(cuttingPoint1, cuttingPoint2 + 1));
        int currentIndex = (cuttingPoint2 + 1) % permutationLength;
        int otherParentIndex = (cuttingPoint2 + 1) % permutationLength;
        while (currentIndex != cuttingPoint1) {
            int gene = (Integer)otherParent.variables().get(otherParentIndex);
            if (!genesInSegment.contains(gene)) {
                offspring.variables().set(currentIndex, gene);
                currentIndex = (currentIndex + 1) % permutationLength;
            }
            otherParentIndex = (otherParentIndex + 1) % permutationLength;
        }
    }

    @Override
    public double crossoverProbability() {
        return this.probability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }

    private boolean isValidPermutation(List<Integer> permutation) {
        HashSet<Integer> uniqueElements = new HashSet<Integer>(permutation);
        return uniqueElements.size() == permutation.size();
    }
}

