/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.permutationsolution.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.IntStream;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;

public class IntegerPermutationSolution
extends AbstractSolution<Integer>
implements PermutationSolution<Integer> {
    public IntegerPermutationSolution(int permutationLength, int numberOfObjectives, int numberOfConstraints) {
        super(permutationLength, numberOfObjectives, numberOfConstraints);
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(permutationLength);
        for (int j = 0; j < permutationLength; ++j) {
            randomSequence.add(j);
        }
        Collections.shuffle(randomSequence);
        IntStream.range(0, permutationLength).forEach(i -> this.variables().set(i, (Integer)randomSequence.get(i)));
    }

    public IntegerPermutationSolution(IntegerPermutationSolution solution) {
        super(solution.getLength(), solution.objectives().length, solution.constraints().length);
        IntStream.range(0, solution.variables().size()).forEach(i -> this.variables().set(i, (Integer)solution.variables().get(i)));
        IntStream.range(0, solution.objectives().length).forEach(i -> {
            this.objectives()[i] = solution.objectives()[i];
        });
        IntStream.range(0, solution.constraints().length).forEach(i -> {
            this.constraints()[i] = solution.constraints()[i];
        });
        this.attributes = new HashMap(solution.attributes);
    }

    public IntegerPermutationSolution copy() {
        return new IntegerPermutationSolution(this);
    }

    @Override
    public int getLength() {
        return this.variables().size();
    }
}

