/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.Arrays;

public class KNearestDistanceCalculator {
    private final int k;
    private final boolean normalize;
    private static final double EPSILON = 1.0E-10;

    public KNearestDistanceCalculator(int k, boolean normalize) {
        if (k <= 0) {
            throw new IllegalArgumentException("k must be positive");
        }
        this.k = k;
        this.normalize = normalize;
    }

    public double[] compute(double[][] matrix) {
        this.validateInput(matrix);
        double[][] data = this.normalize ? this.normalizeMatrix(matrix) : matrix;
        int n = data.length;
        if (this.k >= n) {
            throw new IllegalStateException(String.format("k (%d) must be less than the number of rows - 1 (%d)", this.k, n - 1));
        }
        double[] kthDistances = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] distances = new double[n - 1];
            int idx = 0;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                distances[idx++] = this.euclideanDistance(data[i], data[j]);
            }
            Arrays.sort(distances);
            kthDistances[i] = distances[this.k - 1];
        }
        return kthDistances;
    }

    private void validateInput(double[][] matrix) {
        if (matrix == null || matrix.length == 0) {
            throw new IllegalArgumentException("Input matrix cannot be null or empty");
        }
        int cols = matrix[0].length;
        for (double[] row : matrix) {
            if (row != null && row.length == cols) continue;
            throw new IllegalArgumentException("All rows must have the same number of columns");
        }
    }

    private double[][] normalizeMatrix(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] normalized = new double[rows][cols];
        double[] min = new double[cols];
        double[] max = new double[cols];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        for (double[] row : matrix) {
            for (int j = 0; j < cols; ++j) {
                min[j] = Math.min(min[j], row[j]);
                max[j] = Math.max(max[j], row[j]);
            }
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double range = max[j] - min[j];
                normalized[i][j] = range < 1.0E-10 ? 0.5 : (matrix[i][j] - min[j]) / range;
            }
        }
        return normalized;
    }

    private double euclideanDistance(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff = a[i] - b[i];
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }
}

