/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.Comparator;
import java.util.List;
import java.util.function.BinaryOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class SolutionUtils {
    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator) {
        return SolutionUtils.getBestSolution(solution1, solution2, comparator, () -> JMetalRandom.getInstance().nextDouble());
    }

    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator, RandomGenerator<Double> randomGenerator) {
        return SolutionUtils.getBestSolution(solution1, solution2, comparator, (a, b) -> (Double)randomGenerator.getRandomValue() < 0.5 ? a : b);
    }

    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator, BinaryOperator<S> equalityPolicy) {
        int flag = comparator.compare(solution1, solution2);
        Object result = flag < 0 ? solution1 : (flag > 0 ? solution2 : (Solution)equalityPolicy.apply(solution1, solution2));
        return result;
    }

    public static <S extends Solution<?>> double distanceBetweenObjectives(S firstSolution, S secondSolution) {
        double distance = 0.0;
        for (int nObj = 0; nObj < firstSolution.objectives().length; ++nObj) {
            double diff = firstSolution.objectives()[nObj] - secondSolution.objectives()[nObj];
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public static <S extends Solution<?>> double normalizedDistanceBetweenObjectives(S firstSolution, S secondSolution, double[] maxs, double[] mins) {
        double distance = 0.0;
        for (int nObj = 0; nObj < firstSolution.objectives().length; ++nObj) {
            double diff = firstSolution.objectives()[nObj] / (maxs[nObj] - mins[nObj]) - secondSolution.objectives()[nObj] / (maxs[nObj] - mins[nObj]);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public static double distanceToSolutionListInSolutionSpace(DoubleSolution solution, List<DoubleSolution> solutionList) {
        double distance = Double.MAX_VALUE;
        for (DoubleSolution doubleSolution : solutionList) {
            double aux = SolutionUtils.distanceBetweenSolutionsInObjectiveSpace(solution, doubleSolution);
            if (!(aux < distance)) continue;
            distance = aux;
        }
        return distance;
    }

    public static double distanceBetweenSolutionsInObjectiveSpace(DoubleSolution solutionI, DoubleSolution solutionJ) {
        double distance = 0.0;
        for (int i = 0; i < solutionI.variables().size(); ++i) {
            double diff = (Double)solutionI.variables().get(i) - (Double)solutionJ.variables().get(i);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public static <S extends Solution<?>> double averageDistanceToSolutionList(S solution, List<S> solutionList) {
        double sumOfDistances = 0.0;
        for (Solution sol : solutionList) {
            sumOfDistances += SolutionUtils.distanceBetweenObjectives(solution, sol);
        }
        return sumOfDistances / (double)solutionList.size();
    }

    public static <S extends Solution<?>> S normalize(S solution, double[] minValues, double[] maxValues) {
        if (solution == null) {
            throw new JMetalException("The solution should not be null");
        }
        if (minValues == null || maxValues == null) {
            throw new JMetalException("The minValues and maxValues should not be null");
        }
        if (minValues.length == 0 || maxValues.length == 0) {
            throw new JMetalException("The minValues and maxValues should not be empty");
        }
        if (minValues.length != maxValues.length) {
            throw new JMetalException("The minValues and maxValues should have the same length");
        }
        if (solution.objectives().length != minValues.length) {
            throw new JMetalException("The number of objectives should be the same to min and max length");
        }
        Solution<?> copy = solution.copy();
        for (int i = 0; i < copy.objectives().length; ++i) {
            copy.objectives()[i] = NormalizeUtils.normalize(solution.objectives()[i], minValues[i], maxValues[i]);
        }
        return (S)copy;
    }
}

