/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.ranking.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.dominanceComparator.impl.DominanceWithConstraintsComparator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.ranking.Ranking;

public class StrengthRanking<S extends Solution<?>>
implements Ranking<S> {
    private final String attributeId = this.getClass().getName();
    private Comparator<S> dominanceComparator;
    private List<ArrayList<S>> rankedSubPopulations;

    public StrengthRanking(Comparator<S> comparator) {
        this.dominanceComparator = comparator;
        this.rankedSubPopulations = new ArrayList<ArrayList<S>>();
    }

    public StrengthRanking() {
        this(new DominanceWithConstraintsComparator());
    }

    @Override
    public Ranking<S> compute(List<S> solutionList) {
        int j;
        int i;
        int[] strength = new int[solutionList.size()];
        int[] rawFitness = new int[solutionList.size()];
        for (i = 0; i < solutionList.size(); ++i) {
            for (j = 0; j < solutionList.size(); ++j) {
                if (this.dominanceComparator.compare((Solution)solutionList.get(i), (Solution)solutionList.get(j)) >= 0) continue;
                int n = i;
                strength[n] = strength[n] + 1;
            }
        }
        for (i = 0; i < solutionList.size(); ++i) {
            for (j = 0; j < solutionList.size(); ++j) {
                if (this.dominanceComparator.compare((Solution)solutionList.get(i), (Solution)solutionList.get(j)) != 1) continue;
                int n = i;
                rawFitness[n] = rawFitness[n] + strength[j];
            }
        }
        int maxFitnessValue = 0;
        for (int i2 = 0; i2 < solutionList.size(); ++i2) {
            ((Solution)solutionList.get(i2)).attributes().put(this.attributeId, rawFitness[i2]);
            if (rawFitness[i2] <= maxFitnessValue) continue;
            maxFitnessValue = rawFitness[i2];
        }
        this.rankedSubPopulations = new ArrayList<ArrayList<S>>(maxFitnessValue + 1);
        IntStream.range(0, maxFitnessValue + 1).forEach(index -> this.rankedSubPopulations.add(new ArrayList()));
        solutionList.forEach(solution -> this.rankedSubPopulations.get((Integer)solution.attributes().get(this.attributeId)).add(solution));
        int counter = 0;
        while (counter < this.rankedSubPopulations.size()) {
            if (this.rankedSubPopulations.get(counter).size() == 0) {
                this.rankedSubPopulations.remove(counter);
                continue;
            }
            ++counter;
        }
        return this;
    }

    @Override
    public List<S> getSubFront(int rank) {
        if (rank >= this.rankedSubPopulations.size()) {
            throw new JMetalException("Invalid rank: " + rank + ". Max rank = " + (this.rankedSubPopulations.size() - 1));
        }
        return this.rankedSubPopulations.get(rank);
    }

    @Override
    public int getNumberOfSubFronts() {
        return this.rankedSubPopulations.size();
    }

    @Override
    public Integer getRank(S solution) {
        Check.notNull(solution);
        Integer result = -1;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Integer)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Object getAttributedId() {
        return this.attributeId;
    }
}

