/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class PreferenceDistance<S extends Solution<?>>
extends GenericSolutionAttribute<S, Double>
implements DensityEstimator<S> {
    private List<Double> interestPoint;
    private List<Double> weights = null;
    private double epsilon;

    public PreferenceDistance(List<Double> interestPoint, double epsilon) {
        this.epsilon = epsilon;
        this.interestPoint = interestPoint;
    }

    public void updatePointOfInterest(List<Double> newInterestPoint) {
        this.interestPoint = newInterestPoint;
    }

    public int getSize() {
        return this.weights.size();
    }

    @Override
    public void computeDensityEstimator(List<S> solutionList) {
        int i;
        int size = solutionList.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Solution)solutionList.get(0)).attributes().put(this.getAttributeIdentifier(), Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            ((Solution)solutionList.get(0)).attributes().put(this.getAttributeIdentifier(), Double.POSITIVE_INFINITY);
            ((Solution)solutionList.get(1)).attributes().put(this.getAttributeIdentifier(), Double.POSITIVE_INFINITY);
            return;
        }
        ArrayList<S> front = new ArrayList<S>(size);
        front.addAll(solutionList);
        for (int i2 = 0; i2 < size; ++i2) {
            ((Solution)front.get(i2)).attributes().put(this.getAttributeIdentifier(), 0.0);
        }
        int numberOfObjectives = ((Solution)solutionList.get(0)).objectives().length;
        this.weights = new ArrayList<Double>();
        for (i = 0; i < numberOfObjectives; ++i) {
            this.weights.add(1.0 / (double)numberOfObjectives);
        }
        for (i = 0; i < front.size() - 1; ++i) {
            double normalizeDiff = 0.0;
            double distance = 0.0;
            for (int j = 0; j < numberOfObjectives; ++j) {
                Collections.sort(front, new ObjectiveComparator(j));
                double objetiveMinn = ((Solution)front.get(0)).objectives()[j];
                double objetiveMaxn = ((Solution)front.get(front.size() - 1)).objectives()[j];
                normalizeDiff = (((Solution)front.get(i)).objectives()[j] - this.interestPoint.get(j)) / (objetiveMaxn - objetiveMinn);
                distance += this.weights.get(j) * Math.pow(normalizeDiff, 2.0);
            }
            distance = Math.sqrt(distance);
            ((Solution)front.get(i)).attributes().put(this.getAttributeIdentifier(), distance);
        }
    }

    public List<S> epsilonClean(List<S> solutionList) {
        ArrayList<Solution> preference = new ArrayList<Solution>();
        LinkedList<S> temporalList = new LinkedList<S>(solutionList);
        int numerOfObjectives = ((Solution)solutionList.get(0)).objectives().length;
        while (!temporalList.isEmpty()) {
            int indexRandom = JMetalRandom.getInstance().nextInt(0, temporalList.size() - 1);
            Solution randomSolution = (Solution)temporalList.get(indexRandom);
            preference.add(randomSolution);
            temporalList.remove(indexRandom);
            for (int indexOfSolution = 0; indexOfSolution < temporalList.size(); ++indexOfSolution) {
                double sum = 0.0;
                for (int indexOfObjective = 0; indexOfObjective < numerOfObjectives; ++indexOfObjective) {
                    temporalList.sort(new ObjectiveComparator(indexOfObjective));
                    double objetiveMinn = ((Solution)temporalList.get(0)).objectives()[indexOfObjective];
                    double objetiveMaxn = ((Solution)temporalList.get(temporalList.size() - 1)).objectives()[indexOfObjective];
                    sum += Math.abs(randomSolution.objectives()[indexOfObjective] - ((Solution)temporalList.get(indexOfSolution)).objectives()[indexOfObjective]) / (objetiveMaxn - objetiveMinn);
                }
                if (!(sum < this.epsilon)) continue;
                ((Solution)temporalList.get(indexOfSolution)).attributes().put(this.getAttributeIdentifier(), Double.MAX_VALUE);
                preference.add((Solution)temporalList.get(indexOfSolution));
                temporalList.remove(indexOfSolution);
            }
        }
        return preference;
    }
}

