/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class BLXAlphaBetaCrossover
implements CrossoverOperator<DoubleSolution> {
    public static final double DEFAULT_ALPHA = 0.5;
    public static final double DEFAULT_BETA = 0.5;
    private final double crossoverProbability;
    private final double alpha;
    private final double beta;
    private final RandomGenerator<Double> randomGenerator;
    private final RepairDoubleSolution solutionRepair;

    public BLXAlphaBetaCrossover(double crossoverProbability) {
        this(crossoverProbability, 0.5, 0.5);
    }

    public BLXAlphaBetaCrossover(double crossoverProbability, double alpha, double beta) {
        this(crossoverProbability, alpha, beta, new RepairDoubleSolutionWithBoundValue(), () -> JMetalRandom.getInstance().nextDouble());
    }

    public BLXAlphaBetaCrossover(double crossoverProbability, double alpha, double beta, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, alpha, beta, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public BLXAlphaBetaCrossover(double crossoverProbability, double alpha, double beta, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.that(alpha >= 0.0, "Alpha must be non-negative: " + alpha);
        Check.that(beta >= 0.0, "Beta must be non-negative: " + beta);
        Check.notNull(solutionRepair);
        Check.notNull(randomGenerator);
        this.crossoverProbability = crossoverProbability;
        this.alpha = alpha;
        this.beta = beta;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "BLX-\u03b1\u03b2 Crossover requires exactly two parents");
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        DoubleSolution parent1 = solutions.get(0);
        DoubleSolution parent2 = solutions.get(1);
        DoubleSolution child1 = (DoubleSolution)parent1.copy();
        DoubleSolution child2 = (DoubleSolution)parent2.copy();
        if (this.randomGenerator.getRandomValue() < this.crossoverProbability) {
            int numberOfVariables = parent1.variables().size();
            for (int i = 0; i < numberOfVariables; ++i) {
                double p2;
                double p1 = (Double)parent1.variables().get(i);
                if (p1 > (p2 = ((Double)parent2.variables().get(i)).doubleValue())) {
                    double temp = p1;
                    p1 = p2;
                    p2 = temp;
                }
                double d = p2 - p1;
                double cMin = p1 - this.alpha * d;
                double cMax = p2 + this.beta * d;
                double value1 = cMin + this.randomGenerator.getRandomValue() * (cMax - cMin);
                double value2 = cMin + this.randomGenerator.getRandomValue() * (cMax - cMin);
                double lowerBound = child1.getBounds(i).getLowerBound();
                double upperBound = child1.getBounds(i).getUpperBound();
                value1 = this.solutionRepair.repairSolutionVariableValue(value1, lowerBound, upperBound);
                value2 = this.solutionRepair.repairSolutionVariableValue(value2, lowerBound, upperBound);
                child1.variables().set(i, value1);
                child2.variables().set(i, value2);
            }
        }
        offspring.add(child1);
        offspring.add(child2);
        return offspring;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }
}

