/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class PositionBasedCrossover
implements CrossoverOperator<PermutationSolution<Integer>> {
    private final double probability;
    private final JMetalRandom randomNumberGenerator = JMetalRandom.getInstance();

    public PositionBasedCrossover(double probability) {
        Check.probabilityIsValid(probability);
        this.probability = probability;
    }

    @Override
    public List<PermutationSolution<Integer>> execute(List<PermutationSolution<Integer>> solutions) {
        if (solutions.size() != 2) {
            throw new JMetalException("PositionBasedCrossover requires exactly two parents.");
        }
        PermutationSolution<Integer> parent1 = solutions.get(0);
        PermutationSolution<Integer> parent2 = solutions.get(1);
        ArrayList<PermutationSolution<Integer>> offspring = new ArrayList<PermutationSolution<Integer>>(2);
        offspring.add((PermutationSolution)parent1.copy());
        offspring.add((PermutationSolution)parent2.copy());
        if (this.randomNumberGenerator.nextDouble() < this.probability) {
            List<Integer> child1 = this.positionBasedCrossover(parent1.variables(), parent2.variables());
            List<Integer> child2 = this.positionBasedCrossover(parent2.variables(), parent1.variables());
            for (int i = 0; i < child1.size(); ++i) {
                ((PermutationSolution)offspring.get(0)).variables().set(i, child1.get(i));
                ((PermutationSolution)offspring.get(1)).variables().set(i, child2.get(i));
            }
        }
        return offspring;
    }

    private List<Integer> positionBasedCrossover(List<Integer> parent1, List<Integer> parent2) {
        int size = parent1.size();
        ArrayList<Object> child = new ArrayList<Object>(Collections.nCopies(size, null));
        HashSet<Integer> selectedPositions = new HashSet<Integer>();
        int numberOfPositions = this.randomNumberGenerator.nextInt(1, size / 2);
        while (selectedPositions.size() < numberOfPositions) {
            selectedPositions.add(this.randomNumberGenerator.nextInt(0, size - 1));
        }
        for (Integer pos : selectedPositions) {
            child.set(pos, parent1.get(pos));
        }
        int childIndex = 0;
        for (Integer element : parent2) {
            if (child.contains(element)) continue;
            while (child.get(childIndex) != null) {
                ++childIndex;
            }
            child.set(childIndex, element);
        }
        return child;
    }

    @Override
    public double crossoverProbability() {
        return this.probability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

