/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class UnimodalNormalDistributionCrossover
implements CrossoverOperator<DoubleSolution> {
    private final double crossoverProbability;
    private final double zeta;
    private final double eta;
    private final RepairDoubleSolution solutionRepair;
    private final RandomGenerator<Double> randomGenerator;

    public UnimodalNormalDistributionCrossover(double crossoverProbability) {
        this(crossoverProbability, 0.5, 0.35, new RepairDoubleSolutionWithBoundValue());
    }

    public UnimodalNormalDistributionCrossover(double crossoverProbability, double zeta, double eta, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, zeta, eta, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public UnimodalNormalDistributionCrossover(double crossoverProbability, double zeta, double eta, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.that(zeta >= 0.0, "Zeta must be non-negative: " + zeta);
        Check.that(eta >= 0.0, "Eta must be non-negative: " + eta);
        Check.notNull(solutionRepair);
        Check.notNull(randomGenerator);
        this.crossoverProbability = crossoverProbability;
        this.zeta = zeta;
        this.eta = eta;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() >= 3, "UNDX requires at least 3 parents");
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        DoubleSolution parent1 = solutions.get(0);
        DoubleSolution parent2 = solutions.get(1);
        DoubleSolution parent3 = solutions.get(2);
        if (this.randomGenerator.getRandomValue() < this.crossoverProbability) {
            int numberOfVariables = parent1.variables().size();
            DoubleSolution child1 = (DoubleSolution)parent1.copy();
            DoubleSolution child2 = (DoubleSolution)parent2.copy();
            double[] center = new double[numberOfVariables];
            for (int i = 0; i < numberOfVariables; ++i) {
                center[i] = ((Double)parent1.variables().get(i) + (Double)parent2.variables().get(i)) / 2.0;
            }
            double[] diff = new double[numberOfVariables];
            double distanceSquared = 0.0;
            for (int i = 0; i < numberOfVariables; ++i) {
                diff[i] = (Double)parent2.variables().get(i) - (Double)parent1.variables().get(i);
                distanceSquared += diff[i] * diff[i];
            }
            double distance = Math.sqrt(distanceSquared);
            if (distance < 1.0E-10) {
                offspring.add((DoubleSolution)parent1.copy());
                offspring.add((DoubleSolution)parent2.copy());
                return offspring;
            }
            for (int i = 0; i < numberOfVariables; ++i) {
                double alpha = this.randomGenerator.getRandomValue() * this.zeta * distance;
                double beta = 0.0;
                for (int j = 0; j < 2; ++j) {
                    beta += (this.randomGenerator.getRandomValue() - 0.5) * this.eta * distance;
                }
                double orthogonal = ((Double)parent3.variables().get(i) - center[i]) / distance;
                double value1 = center[i] + alpha * diff[i] / distance + beta * orthogonal;
                double value2 = center[i] - alpha * diff[i] / distance - beta * orthogonal;
                double lowerBound = child1.getBounds(i).getLowerBound();
                double upperBound = child1.getBounds(i).getUpperBound();
                child1.variables().set(i, this.solutionRepair.repairSolutionVariableValue(value1, lowerBound, upperBound));
                lowerBound = child2.getBounds(i).getLowerBound();
                upperBound = child2.getBounds(i).getUpperBound();
                child2.variables().set(i, this.solutionRepair.repairSolutionVariableValue(value2, lowerBound, upperBound));
            }
            offspring.add(child1);
            offspring.add(child2);
        } else {
            offspring.add((DoubleSolution)parent1.copy());
            offspring.add((DoubleSolution)parent2.copy());
        }
        return offspring;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 3;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }

    public double zeta() {
        return this.zeta;
    }

    public double eta() {
        return this.eta;
    }
}

