/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class LinkedPolynomialMutation
implements MutationOperator<DoubleSolution> {
    private static final double DEFAULT_DISTRIBUTION_INDEX = 20.0;
    private double distributionIndex;
    private double mutationProbability;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public LinkedPolynomialMutation(double mutationProbability) {
        this(mutationProbability, 20.0);
    }

    public LinkedPolynomialMutation(DoubleProblem problem, double distributionIndex, RandomGenerator<Double> randomGenerator) {
        this(1.0 / (double)problem.numberOfVariables(), distributionIndex);
        this.randomGenerator = randomGenerator;
    }

    public LinkedPolynomialMutation(double mutationProbability, double distributionIndex) {
        this(mutationProbability, distributionIndex, new RepairDoubleSolutionWithBoundValue());
    }

    public LinkedPolynomialMutation(double mutationProbability, double distributionIndex, RandomGenerator<Double> randomGenerator) {
        this(mutationProbability, distributionIndex, new RepairDoubleSolutionWithBoundValue(), randomGenerator);
    }

    public LinkedPolynomialMutation(double mutationProbability, double distributionIndex, RepairDoubleSolution solutionRepair) {
        this(mutationProbability, distributionIndex, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public LinkedPolynomialMutation(double mutationProbability, double distributionIndex, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.that(distributionIndex >= 0.0, "Distribution index is negative: " + distributionIndex);
        Check.probabilityIsValid(mutationProbability);
        this.mutationProbability = mutationProbability;
        this.distributionIndex = distributionIndex;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    public void setMutationProbability(double probability) {
        this.mutationProbability = probability;
    }

    public void setDistributionIndex(double distributionIndex) {
        this.distributionIndex = distributionIndex;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) throws JMetalException {
        Check.notNull(solution);
        this.doMutation(solution);
        return solution;
    }

    public double[] execute(double[] x, double[] lowerBound, double[] upperBound) {
        double rnd = this.randomGenerator.getRandomValue();
        for (int i = 0; i < x.length; ++i) {
            if (!(this.randomGenerator.getRandomValue() <= this.mutationProbability)) continue;
            double y = x[i];
            double yl = lowerBound[i];
            double yu = upperBound[i];
            if (yl == yu) {
                y = yl;
            } else {
                double deltaq;
                double val;
                double xy;
                double delta1 = (y - yl) / (yu - yl);
                double delta2 = (yu - y) / (yu - yl);
                double mutPow = 1.0 / (this.distributionIndex + 1.0);
                if (rnd <= 0.5) {
                    xy = 1.0 - delta1;
                    val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = Math.pow(val, mutPow) - 1.0;
                } else {
                    xy = 1.0 - delta2;
                    val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = 1.0 - Math.pow(val, mutPow);
                }
                y += deltaq * (yu - yl);
                y = this.solutionRepair.repairSolutionVariableValue(y, yl, yu);
            }
            x[i] = y;
        }
        return x;
    }

    private void doMutation(DoubleSolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            double yu;
            if (!(this.randomGenerator.getRandomValue() <= this.mutationProbability)) continue;
            double y = (Double)solution.variables().get(i);
            Bounds<Double> bounds = solution.getBounds(i);
            double yl = bounds.getLowerBound();
            if (yl == (yu = bounds.getUpperBound().doubleValue())) {
                y = yl;
            } else {
                double deltaq;
                double val;
                double xy;
                double delta1 = (y - yl) / (yu - yl);
                double delta2 = (yu - y) / (yu - yl);
                double rnd = this.randomGenerator.getRandomValue();
                double mutPow = 1.0 / (this.distributionIndex + 1.0);
                if (rnd <= 0.5) {
                    xy = 1.0 - delta1;
                    val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = Math.pow(val, mutPow) - 1.0;
                } else {
                    xy = 1.0 - delta2;
                    val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = 1.0 - Math.pow(val, mutPow);
                }
                y += deltaq * (yu - yl);
                y = this.solutionRepair.repairSolutionVariableValue(y, yl, yu);
            }
            solution.variables().set(i, y);
        }
    }
}

