/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.doubleproblem.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;

public class ComposableDoubleProblem
implements DoubleProblem {
    private List<Function<Double[], Double>> objectiveFunctions = new ArrayList<Function<Double[], Double>>();
    private List<Function<Double[], Double>> constraints = new ArrayList<Function<Double[], Double>>();
    private List<Bounds<Double>> bounds = new ArrayList<Bounds<Double>>();
    private String name = "";

    public ComposableDoubleProblem addFunction(Function<Double[], Double> objective) {
        this.objectiveFunctions.add(objective);
        return this;
    }

    public ComposableDoubleProblem addConstraint(Function<Double[], Double> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public ComposableDoubleProblem addVariable(double lowerBound, double upperBound) {
        this.bounds.add(Bounds.create(lowerBound, upperBound));
        return this;
    }

    public ComposableDoubleProblem name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public int numberOfVariables() {
        return this.bounds.size();
    }

    @Override
    public int numberOfObjectives() {
        return this.objectiveFunctions.size();
    }

    @Override
    public int numberOfConstraints() {
        return this.constraints.size();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DoubleSolution createSolution() {
        return new DefaultDoubleSolution(this.bounds, this.numberOfObjectives(), this.numberOfConstraints());
    }

    @Override
    public List<Bounds<Double>> variableBounds() {
        return this.bounds;
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        Double[] vars = solution.variables().toArray(new Double[this.numberOfVariables()]);
        IntStream.range(0, this.numberOfObjectives()).forEach(i -> {
            solution.objectives()[i] = this.objectiveFunctions.get(i).apply(vars);
        });
        IntStream.range(0, this.numberOfConstraints()).forEach(i -> {
            solution.constraints()[i] = this.constraints.get(i).apply(vars);
        });
        return solution;
    }
}

