/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.util.JMetalLogger;

public class NormalizedHypervolume
extends QualityIndicator {
    private double referenceFrontHypervolume;
    private Hypervolume hypervolume;

    public NormalizedHypervolume() {
    }

    public NormalizedHypervolume(double[] referencePoint) {
        double[][] referenceFront = new double[][]{referencePoint};
        this.hypervolume = new PISAHypervolume(referenceFront);
    }

    public NormalizedHypervolume(double[][] referenceFront) {
        super(referenceFront);
        this.hypervolume = new PISAHypervolume(referenceFront);
    }

    @Override
    public QualityIndicator newInstance() {
        return new NormalizedHypervolume();
    }

    @Override
    public void referenceFront(double[][] referenceFront) {
        super.referenceFront(referenceFront);
        this.hypervolume = new PISAHypervolume(referenceFront);
    }

    @Override
    public String name() {
        return "NHV";
    }

    @Override
    public String description() {
        return "Normalized hypervolume";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }

    @Override
    public double compute(double[][] front) {
        this.referenceFrontHypervolume = this.hypervolume.compute(this.referenceFront);
        double hypervolumeValue = this.hypervolume.compute(front);
        double result = 1.0 - hypervolumeValue / this.referenceFrontHypervolume;
        if (result < 0.0) {
            JMetalLogger.logger.info("The normalized hypervolue value is negative: ");
            JMetalLogger.logger.info("- HV reference front: " + this.referenceFrontHypervolume);
            JMetalLogger.logger.info("- HV current front  : " + hypervolumeValue);
        }
        return result;
    }
}

