/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import org.uma.jmetal.util.errorchecking.Check;

public class ReferencePointUtils {
    public static double[][] createReferenceFrontFromReferencePoint(double[] referencePoint) {
        Check.notNull(referencePoint);
        Check.that(referencePoint.length > 0, "The reference point cannot be empty");
        int numberOfObjectives = referencePoint.length;
        double[][] referenceFront = new double[numberOfObjectives][numberOfObjectives];
        for (int i = 0; i < numberOfObjectives; ++i) {
            double[] point = new double[numberOfObjectives];
            for (int j = 0; j < numberOfObjectives; ++j) {
                point[j] = j == i ? referencePoint[i] : 0.0;
            }
            referenceFront[i] = point;
        }
        return referenceFront;
    }

    public static double[] extractReferencePointFromReferenceFront(double[][] referenceFront) {
        Check.notNull(referenceFront);
        Check.that(referenceFront.length > 0, "The reference front cannot be empty");
        int numberOfObjectives = referenceFront[0].length;
        double[] referencePoint = new double[numberOfObjectives];
        for (int i = 0; i < numberOfObjectives; ++i) {
            referencePoint[i] = Double.NEGATIVE_INFINITY;
        }
        for (double[] point : referenceFront) {
            if (point == null) {
                throw new IllegalArgumentException("The reference front contains null points");
            }
            if (point.length != numberOfObjectives) {
                throw new IllegalArgumentException("All points in the reference front must have the same number of objectives");
            }
            for (int i = 0; i < numberOfObjectives; ++i) {
                if (!(point[i] > referencePoint[i])) continue;
                referencePoint[i] = point[i];
            }
        }
        return referencePoint;
    }
}

