/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.SpatialSpreadDeviationComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.SpatialSpreadDeviation;

public class SpatialSpreadDeviationArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> crowdingDistanceComparator = new SpatialSpreadDeviationComparator();
    private DensityEstimator<S> crowdingDistance = new SpatialSpreadDeviation();

    public SpatialSpreadDeviationArchive(int maxSize) {
        super(maxSize);
    }

    @Override
    public void prune() {
        if (this.solutions().size() > this.maximumSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.solutions(), this.crowdingDistanceComparator);
            this.solutions().remove(worst);
        }
    }

    @Override
    public Comparator<S> comparator() {
        return this.crowdingDistanceComparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.crowdingDistance.computeDensityEstimator(this.solutions());
    }
}

