/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchart.XYChart;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.plot.FrontScatterPlot;
import org.uma.jmetal.util.point.impl.IdealPoint;
import org.uma.jmetal.util.point.impl.NadirPoint;

public class EstimatingIdealAndNadirPointsPlotObserver<S extends Solution<?>>
implements Observer<Map<String, Object>> {
    private final FrontScatterPlot chart;
    private Integer evaluations;
    private final int plotUpdateFrequency;
    private IdealPoint idealPoint = null;
    private NadirPoint nadirPoint = null;
    private String plotTitle;
    private NonDominatedSolutionListArchive<S> nonDominatedSolutionListArchive;

    public EstimatingIdealAndNadirPointsPlotObserver(String title, String xAxisTitle, String yAxisTitle, String legend, int plotUpdateFrequency, long delay) {
        this.chart = new FrontScatterPlot(title, xAxisTitle, yAxisTitle, legend);
        this.plotUpdateFrequency = plotUpdateFrequency;
        this.plotTitle = title;
        this.setPoint(0.0, 0.0, "Ideal point");
        this.setPoint(0.0, 0.0, "Nadir point");
        this.nonDominatedSolutionListArchive = new NonDominatedSolutionListArchive();
        this.chart.delay(delay);
    }

    public void setFront(double[][] front, String frontName) {
        this.chart.setFront(front, frontName);
    }

    public void setPoint(double x, double y, String pointName) {
        this.chart.addPoint(x, y, pointName);
    }

    public void updatePoint(double x, double y, String pointName) {
        this.chart.updatePoint(x, y, pointName);
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        this.evaluations = (Integer)data.get("EVALUATIONS");
        List population = (List)data.get("POPULATION");
        Check.notNull(population);
        if (this.evaluations != null) {
            if (this.evaluations % this.plotUpdateFrequency == 0) {
                this.nonDominatedSolutionListArchive = new NonDominatedSolutionListArchive();
                this.nonDominatedSolutionListArchive.addAll(population);
                if (this.idealPoint == null) {
                    this.idealPoint = new IdealPoint(((Solution)population.get(0)).objectives().length);
                }
                this.nadirPoint = new NadirPoint(((Solution)population.get(0)).objectives().length);
                this.idealPoint.update(this.nonDominatedSolutionListArchive.solutions());
                this.nadirPoint.update(this.nonDominatedSolutionListArchive.solutions());
                List<S> solutionsToPlot = this.nonDominatedSolutionListArchive.solutions();
                List<Double> objective1 = solutionsToPlot.stream().map(s -> s.objectives()[0]).collect(Collectors.toList());
                List<Double> objective2 = solutionsToPlot.stream().map(s -> s.objectives()[1]).collect(Collectors.toList());
                this.chart.chartTitle(this.plotTitle + ". Evaluations: " + this.evaluations);
                this.chart.updatePoint(this.idealPoint.value(0), this.idealPoint.value(1), "Ideal point");
                this.chart.updatePoint(this.nadirPoint.value(0), this.nadirPoint.value(1), "Nadir point");
                this.chart.updateChart(objective1, objective2);
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + " : insufficient for generating real time information. Either EVALUATIONS or POPULATION keys have not been registered yet by the algorithm");
        }
    }

    public XYChart chart() {
        return this.chart.chart();
    }
}

