/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.ranking.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.dominanceComparator.impl.DefaultDominanceComparator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.ranking.Ranking;

public class FastNonDominatedSortRanking<S extends Solution<?>>
implements Ranking<S> {
    private String attributeId = this.getClass().getName();
    private Comparator<S> dominanceComparator;
    private List<ArrayList<S>> rankedSubPopulations;

    public FastNonDominatedSortRanking(Comparator<S> comparator) {
        this.dominanceComparator = comparator;
        this.rankedSubPopulations = new ArrayList<ArrayList<S>>();
    }

    public FastNonDominatedSortRanking() {
        this(new DefaultDominanceComparator());
    }

    @Override
    public Ranking<S> compute(List<S> solutionList) {
        int i;
        List<S> population = solutionList;
        int[] dominateMe = new int[population.size()];
        ArrayList iDominate = new ArrayList(population.size());
        ArrayList front = new ArrayList(population.size() + 1);
        for (int i2 = 0; i2 < population.size() + 1; ++i2) {
            front.add(new LinkedList());
        }
        for (int p = 0; p < population.size(); ++p) {
            iDominate.add(new LinkedList());
            dominateMe[p] = 0;
        }
        for (int p = 0; p < population.size() - 1; ++p) {
            for (int q = p + 1; q < population.size(); ++q) {
                int flagDominate = this.dominanceComparator.compare((Solution)solutionList.get(p), (Solution)solutionList.get(q));
                if (flagDominate == -1) {
                    ((List)iDominate.get(p)).add(q);
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                ((List)iDominate.get(q)).add(p);
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (i = 0; i < population.size(); ++i) {
            if (dominateMe[i] != 0) continue;
            ((List)front.get(0)).add(i);
            ((Solution)solutionList.get(i)).attributes().put(this.attributeId, 0);
        }
        i = 0;
        while (!((List)front.get(i)).isEmpty()) {
            Iterator it1 = ((List)front.get(++i - 1)).iterator();
            while (it1.hasNext()) {
                Iterator it2 = ((List)iDominate.get((Integer)it1.next())).iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    ((List)front.get(i)).add(index);
                    ((Solution)solutionList.get(index)).attributes().put(this.attributeId, i);
                }
            }
        }
        this.rankedSubPopulations = new ArrayList<ArrayList<S>>();
        for (int j = 0; j < i; ++j) {
            this.rankedSubPopulations.add(j, new ArrayList(((List)front.get(j)).size()));
            Iterator it1 = ((List)front.get(j)).iterator();
            while (it1.hasNext()) {
                this.rankedSubPopulations.get(j).add((Solution)solutionList.get((Integer)it1.next()));
            }
        }
        return this;
    }

    @Override
    public List<S> getSubFront(int rank) {
        Check.that(rank < this.rankedSubPopulations.size(), "Invalid rank: " + rank + ". Max rank = " + (this.rankedSubPopulations.size() - 1));
        return this.rankedSubPopulations.get(rank);
    }

    @Override
    public int getNumberOfSubFronts() {
        return this.rankedSubPopulations.size();
    }

    @Override
    public Integer getRank(S solution) {
        Check.notNull(solution);
        Integer result = -1;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Integer)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Object getAttributedId() {
        return this.attributeId;
    }
}

