/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.sequencegenerator.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public final class CyclicIntegerSequence
implements SequenceGenerator<Integer> {
    private final AtomicInteger index;
    private final int size;

    public CyclicIntegerSequence(int size) {
        Check.that(size > 0, "Size " + size + " must be positive");
        this.size = size;
        this.index = new AtomicInteger(0);
    }

    @Override
    public Integer getValue() {
        return this.index.get();
    }

    @Override
    public void generateNext() {
        this.index.updateAndGet(current -> (current + 1) % this.size);
    }

    @Override
    public int getSequenceLength() {
        return this.size;
    }

    public String toString() {
        return "CyclicIntegerSequence{size=" + this.size + ", currentIndex=" + this.index.get() + "}";
    }
}

