/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.sequencegenerator.impl;

import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class RandomPermutationCycle
implements SequenceGenerator<Integer> {
    private int[] sequence;
    private int index;
    private final int size;
    private final JMetalRandom randomGenerator = JMetalRandom.getInstance();

    public RandomPermutationCycle(int size) {
        Check.that(size > 0, "Size " + size + " must be positive");
        this.size = size;
        this.sequence = this.randomPermutation(size);
        this.index = 0;
    }

    @Override
    public Integer getValue() {
        return this.sequence[this.index];
    }

    @Override
    public void generateNext() {
        ++this.index;
        if (this.index == this.sequence.length) {
            this.sequence = this.randomPermutation(this.size);
            this.index = 0;
        }
    }

    private int[] randomPermutation(int size) {
        int[] permutation = new int[size];
        int[] index = new int[size];
        boolean[] flag = new boolean[size];
        for (int n = 0; n < size; ++n) {
            index[n] = n;
            flag[n] = true;
        }
        block1: for (int num = 0; num < size; ++num) {
            int start = this.randomGenerator.nextInt(0, size - 1);
            while (true) {
                if (flag[start]) {
                    permutation[num] = index[start];
                    flag[start] = false;
                    continue block1;
                }
                start = start == size - 1 ? 0 : start + 1;
            }
        }
        return permutation;
    }

    @Override
    public int getSequenceLength() {
        return this.size;
    }
}

