/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class BLXAlphaCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double DEFAULT_ALPHA = 0.5;
    private double crossoverProbability;
    private double alpha;
    private final RepairDoubleSolution solutionRepair;
    private final RandomGenerator<Double> randomGenerator;

    public BLXAlphaCrossover(double crossoverProbability) {
        this(crossoverProbability, 0.5, new RepairDoubleSolutionWithBoundValue());
    }

    public BLXAlphaCrossover(double crossoverProbability, double alpha) {
        this(crossoverProbability, alpha, new RepairDoubleSolutionWithBoundValue());
    }

    public BLXAlphaCrossover(double crossoverProbability, double alpha, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, alpha, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public BLXAlphaCrossover(double crossoverProbability, double alpha, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.that(alpha >= 0.0, "Alpha is negative: " + alpha);
        this.crossoverProbability = crossoverProbability;
        this.alpha = alpha;
        this.randomGenerator = randomGenerator;
        this.solutionRepair = solutionRepair;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    public double alpha() {
        return this.alpha;
    }

    public void crossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    public void alpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "There must be two parents instead of " + solutions.size());
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<DoubleSolution> doCrossover(double probability, DoubleSolution parent1, DoubleSolution parent2) {
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        offspring.add((DoubleSolution)parent1.copy());
        offspring.add((DoubleSolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() <= probability) {
            for (int i = 0; i < parent1.variables().size(); ++i) {
                double min;
                double max;
                Bounds<Double> bounds = parent1.getBounds(i);
                double upperBound = bounds.getUpperBound();
                double lowerBound = bounds.getLowerBound();
                double valueX1 = (Double)parent1.variables().get(i);
                double valueX2 = (Double)parent2.variables().get(i);
                if (valueX2 > valueX1) {
                    max = valueX2;
                    min = valueX1;
                } else {
                    max = valueX1;
                    min = valueX2;
                }
                double range = max - min;
                double minRange = min - range * this.alpha;
                double maxRange = max + range * this.alpha;
                double random = this.randomGenerator.getRandomValue();
                double valueY1 = minRange + random * (maxRange - minRange);
                random = this.randomGenerator.getRandomValue();
                double valueY2 = minRange + random * (maxRange - minRange);
                valueY1 = this.solutionRepair.repairSolutionVariableValue(valueY1, lowerBound, upperBound);
                valueY2 = this.solutionRepair.repairSolutionVariableValue(valueY2, lowerBound, upperBound);
                ((DoubleSolution)offspring.get(0)).variables().set(i, valueY1);
                ((DoubleSolution)offspring.get(1)).variables().set(i, valueY2);
            }
        }
        return offspring;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

