/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class CycleCrossover
implements CrossoverOperator<PermutationSolution<Integer>> {
    private final double probability;
    private final JMetalRandom randomNumberGenerator = JMetalRandom.getInstance();

    public CycleCrossover(double probability) {
        Check.probabilityIsValid(probability);
        this.probability = probability;
    }

    @Override
    public List<PermutationSolution<Integer>> execute(List<PermutationSolution<Integer>> solutions) {
        if (solutions.size() != 2) {
            throw new JMetalException("CycleCrossover requires exactly two parents.");
        }
        PermutationSolution<Integer> parent1 = solutions.get(0);
        PermutationSolution<Integer> parent2 = solutions.get(1);
        ArrayList<PermutationSolution<Integer>> offspring = new ArrayList<PermutationSolution<Integer>>(2);
        offspring.add((PermutationSolution)parent1.copy());
        offspring.add((PermutationSolution)parent2.copy());
        if (this.randomNumberGenerator.nextDouble() < this.probability) {
            int i;
            int index;
            int permutationLength = parent1.variables().size();
            ArrayList<Integer> cycle1 = new ArrayList<Integer>(permutationLength);
            ArrayList<Integer> cycle2 = new ArrayList<Integer>(permutationLength);
            for (int i2 = 0; i2 < permutationLength; ++i2) {
                cycle1.add(-1);
                cycle2.add(-1);
            }
            int start = index = this.randomNumberGenerator.nextInt(0, permutationLength - 1);
            do {
                cycle1.set(index, (Integer)parent1.variables().get(index));
            } while ((index = parent1.variables().indexOf(parent2.variables().get(index))) != start);
            for (i = 0; i < permutationLength; ++i) {
                if ((Integer)cycle1.get(i) == -1) {
                    cycle1.set(i, (Integer)parent2.variables().get(i));
                    cycle2.set(i, (Integer)parent1.variables().get(i));
                    continue;
                }
                cycle2.set(i, (Integer)parent2.variables().get(i));
            }
            for (i = 0; i < permutationLength; ++i) {
                ((PermutationSolution)offspring.get(0)).variables().set(i, (Integer)cycle1.get(i));
                ((PermutationSolution)offspring.get(1)).variables().set(i, (Integer)cycle2.get(i));
            }
        }
        return offspring;
    }

    @Override
    public double crossoverProbability() {
        return this.probability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

