/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.doublesolution.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class FuzzyRecombinationCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double EPSILON = 1.0E-10;
    private final double crossoverProbability;
    private final double alpha;
    private final RepairDoubleSolution solutionRepair;
    private final RandomGenerator<Double> randomGenerator;

    public FuzzyRecombinationCrossover(double crossoverProbability) {
        this(crossoverProbability, 1.0, new RepairDoubleSolutionWithBoundValue());
    }

    public FuzzyRecombinationCrossover(double crossoverProbability, double alpha, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, alpha, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public FuzzyRecombinationCrossover(double crossoverProbability, double alpha, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.that(alpha > 0.0, "Alpha must be positive: " + alpha);
        Check.notNull(solutionRepair);
        Check.notNull(randomGenerator);
        this.crossoverProbability = crossoverProbability;
        this.alpha = alpha;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "FR requires exactly two parents");
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        DoubleSolution parent1 = solutions.get(0);
        DoubleSolution parent2 = solutions.get(1);
        if (this.randomGenerator.getRandomValue() < this.crossoverProbability) {
            int numberOfVariables = parent1.variables().size();
            DoubleSolution child1 = (DoubleSolution)parent1.copy();
            DoubleSolution child2 = (DoubleSolution)parent2.copy();
            for (int i = 0; i < numberOfVariables; ++i) {
                double p2;
                double p1 = (Double)parent1.variables().get(i);
                if (Math.abs(p1 - (p2 = ((Double)parent2.variables().get(i)).doubleValue())) < 1.0E-10) continue;
                double min = Math.min(p1, p2);
                double max = Math.max(p1, p2);
                double range = max - min;
                double spread = this.alpha * range;
                double beta = this.randomGenerator.getRandomValue();
                double value1 = min + beta * spread;
                double value2 = max - (1.0 - beta) * spread;
                double lowerBound = child1.getBounds(i).getLowerBound();
                double upperBound = child1.getBounds(i).getUpperBound();
                child1.variables().set(i, this.solutionRepair.repairSolutionVariableValue(value1, lowerBound, upperBound));
                child2.variables().set(i, this.solutionRepair.repairSolutionVariableValue(value2, lowerBound, upperBound));
            }
            offspring.add(child1);
            offspring.add(child2);
        } else {
            offspring.add((DoubleSolution)parent1.copy());
            offspring.add((DoubleSolution)parent2.copy());
        }
        return offspring;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }

    public double alpha() {
        return this.alpha;
    }
}

