/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class InsertMutation<T>
implements MutationOperator<PermutationSolution<T>> {
    private double mutationProbability;
    private final JMetalRandom randomNumberGenerator = JMetalRandom.getInstance();

    public InsertMutation(double mutationProbability) {
        Check.probabilityIsValid(mutationProbability);
        this.mutationProbability = mutationProbability;
    }

    @Override
    public double mutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        Check.probabilityIsValid(mutationProbability);
        this.mutationProbability = mutationProbability;
    }

    @Override
    public PermutationSolution<T> execute(PermutationSolution<T> solution) {
        Check.notNull(solution);
        this.doMutation(solution);
        return solution;
    }

    public void doMutation(PermutationSolution<T> solution) {
        int permutationLength = solution.variables().size();
        if (permutationLength > 1 && this.randomNumberGenerator.nextDouble() < this.mutationProbability) {
            int pos1 = this.randomNumberGenerator.nextInt(0, permutationLength - 1);
            int pos2 = this.randomNumberGenerator.nextInt(0, permutationLength - 1);
            while (pos1 == pos2) {
                pos2 = this.randomNumberGenerator.nextInt(0, permutationLength - 1);
            }
            Object valueToInsert = solution.variables().get(pos1);
            solution.variables().remove(pos1);
            if (pos1 < pos2) {
                solution.variables().add(pos2 - 1, valueToInsert);
            } else {
                solution.variables().add(pos2, valueToInsert);
            }
        }
    }
}

