/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class InvertedGenerationalDistance
extends QualityIndicator {
    private double pow = 2.0;

    public InvertedGenerationalDistance() {
    }

    public InvertedGenerationalDistance(double[][] referenceFront) {
        super(referenceFront);
    }

    public InvertedGenerationalDistance(double[][] referenceFront, double pow) {
        super(referenceFront);
        this.pow = pow;
    }

    @Override
    public QualityIndicator newInstance() {
        return new InvertedGenerationalDistance();
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.invertedGenerationalDistance(front, this.referenceFront);
    }

    public double invertedGenerationalDistance(double[][] front, double[][] referenceFront) {
        double sum = 0.0;
        for (double[] vector : referenceFront) {
            sum += Math.pow(VectorUtils.distanceToClosestVector(vector, front), this.pow);
        }
        sum = Math.pow(sum, 1.0 / this.pow);
        return sum / (double)referenceFront.length;
    }

    @Override
    public String name() {
        return "IGD";
    }

    @Override
    public String description() {
        return "Inverted generational distance quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

