/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class SetCoverage
extends QualityIndicator {
    public SetCoverage() {
    }

    public SetCoverage(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public QualityIndicator newInstance() {
        return new SetCoverage();
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.compute(front, this.referenceFront);
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return false;
    }

    public double compute(double[][] front, double[][] referenceFront) {
        double result;
        Check.notNull(front);
        Check.notNull(referenceFront);
        int sum = 0;
        if (referenceFront.length == 0) {
            result = front.length == 0 ? 0.0 : 1.0;
        } else {
            for (double[] vector : referenceFront) {
                if (!VectorUtils.isVectorDominatedByAFront(vector, front)) continue;
                ++sum;
            }
            result = (double)sum / (double)referenceFront.length;
        }
        return result;
    }

    @Override
    public String name() {
        return "SC";
    }

    @Override
    public String description() {
        return "Set coverage";
    }
}

