/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl.hypervolume;

import java.util.Objects;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.ReferencePointUtils;

public abstract class Hypervolume
extends QualityIndicator {
    public Hypervolume() {
    }

    public Hypervolume(double[][] referenceFront) {
        super(Objects.requireNonNull(referenceFront, "The reference front cannot be null"));
        if (referenceFront.length == 0) {
            throw new IllegalArgumentException("The reference front cannot be empty");
        }
    }

    public Hypervolume(double[] referencePoint) {
        this(ReferencePointUtils.createReferenceFrontFromReferencePoint(referencePoint));
    }

    public double[] getReferencePoint() {
        if (this.referenceFront == null || this.referenceFront.length == 0) {
            throw new IllegalStateException("No reference front has been set");
        }
        return ReferencePointUtils.extractReferencePointFromReferenceFront(this.referenceFront);
    }

    public void setReferencePoint(double[] referencePoint) {
        this.referenceFront = ReferencePointUtils.createReferenceFrontFromReferencePoint(referencePoint);
    }

    @Override
    public String name() {
        return "HV";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return false;
    }
}

