/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AdaptiveGrid;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.errorchecking.Check;

public class GridDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private final String attributeId = this.getClass().getName();
    private final AdaptiveGrid<S> grid;

    public GridDensityEstimator(int bisections, int numberOfObjectives) {
        this.grid = new AdaptiveGrid(bisections, numberOfObjectives);
    }

    @Override
    public void compute(List<S> solutionList) {
        int size = solutionList.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Solution)solutionList.get(0)).attributes().put(this.attributeId, Double.MAX_VALUE);
        }
        this.grid.updateGrid(solutionList);
        for (Solution solution : solutionList) {
            solution.attributes().put(this.attributeId, this.grid.getLocationDensity(this.grid.location(solution)));
        }
    }

    @Override
    public Double value(S solution) {
        Check.notNull(solution);
        int result = 0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Integer)solution.attributes().get(this.attributeId);
        }
        return (double)result * 1.0;
    }

    @Override
    public Comparator<S> comparator() {
        return Comparator.comparing(this::value);
    }
}

