/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.grouping.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.grouping.CollectionGrouping;

public abstract class ListGrouping<C extends Comparable<C>>
implements CollectionGrouping<List<C>> {
    protected final int numberOfGroups;
    protected List<Integer> indices;
    protected List<List<Integer>> groups;

    protected ListGrouping(int numberOfGroups) {
        this.numberOfGroups = numberOfGroups;
        this.groups = new ArrayList<List<Integer>>(numberOfGroups);
    }

    protected void createGroups() {
        int groupSize = this.computeGroupSize();
        int index = this.groupValues(groupSize);
        this.fillRemainingIndices(index);
    }

    private int groupValues(int groupSize) {
        int index = 0;
        for (int i = 0; i < this.numberOfGroups; ++i) {
            this.groups.add(new ArrayList());
            for (int j = 0; j < groupSize; ++j) {
                this.groups.get(i).add(this.indices.get(index++));
            }
        }
        return index;
    }

    private void fillRemainingIndices(int index) {
        int lastGroupIndex = this.groups.size() - 1;
        while (index < this.indices.size()) {
            this.groups.get(lastGroupIndex).add(this.indices.get(index++));
        }
    }

    private int computeGroupSize() {
        return this.indices.size() / this.numberOfGroups;
    }

    @Override
    public int numberOfGroups() {
        return this.numberOfGroups;
    }

    @Override
    public List<Integer> group(int groupIndex) {
        Check.that(groupIndex >= 0 && groupIndex < this.numberOfGroups, "The group index " + groupIndex + " is invalid");
        return this.groups.get(groupIndex);
    }
}

