/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.restartstrategy.impl;

import java.util.List;
import org.uma.jmetal.problem.DynamicProblem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.restartstrategy.RemoveSolutionsStrategy;

public class RemoveNSolutionsAccordingToTheCrowdingDistance<S extends Solution<?>>
implements RemoveSolutionsStrategy<S> {
    private int numberOfSolutionsToDelete;

    public RemoveNSolutionsAccordingToTheCrowdingDistance(int numberOfSolutionsToDelete) {
        this.numberOfSolutionsToDelete = numberOfSolutionsToDelete;
    }

    @Override
    public int remove(List<S> solutionList, DynamicProblem<S, ?> problem) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (problem == null) {
            throw new JMetalException("The problem is null");
        }
        int numberOfSolutions = solutionList.size() - this.numberOfSolutionsToDelete;
        if (numberOfSolutions < 0) {
            numberOfSolutions = solutionList.size();
        }
        CrowdingDistanceArchive<Solution> archive = new CrowdingDistanceArchive<Solution>(numberOfSolutions);
        for (Solution solution : solutionList) {
            archive.add(solution);
        }
        solutionList.clear();
        solutionList.addAll(archive.solutions());
        return numberOfSolutions;
    }
}

