/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class SpatialSpreadDeviation<S extends Solution<?>>
extends GenericSolutionAttribute<S, Double>
implements DensityEstimator<S> {
    @Override
    public void computeDensityEstimator(List<S> solutionList) {
        int i;
        int size = solutionList.size();
        if (size <= ((Solution)solutionList.get(0)).objectives().length) {
            for (int x = 0; x < size; ++x) {
                ((Solution)solutionList.get(x)).attributes().put(this.getAttributeID(), Double.POSITIVE_INFINITY);
            }
            return;
        }
        ArrayList<S> front = new ArrayList<S>(size);
        front.addAll(solutionList);
        for (int i2 = 0; i2 < size; ++i2) {
            ((Solution)front.get(i2)).attributes().put(this.getAttributeID(), 0.0);
        }
        int numberOfObjectives = ((Solution)solutionList.get(0)).objectives().length;
        double[] objetiveMaxn = new double[numberOfObjectives];
        double[] objetiveMinn = new double[numberOfObjectives];
        for (int i3 = 0; i3 < numberOfObjectives; ++i3) {
            Collections.sort(front, new ObjectiveComparator(i3));
            objetiveMinn[i3] = ((Solution)front.get(0)).objectives()[i3];
            objetiveMaxn[i3] = ((Solution)front.get(front.size() - 1)).objectives()[i3];
            ((Solution)front.get(0)).attributes().put(this.getAttributeID(), Double.POSITIVE_INFINITY);
            ((Solution)front.get(size - 1)).attributes().put(this.getAttributeID(), Double.POSITIVE_INFINITY);
        }
        double[][] distance = SolutionListUtils.normalizedDistanceMatrix(front, objetiveMaxn, objetiveMinn);
        double dminn = Double.MAX_VALUE;
        double dmaxx = 0.0;
        for (i = 0; i < distance.length; ++i) {
            for (int j = 0; j < distance.length; ++j) {
                if (i == j) continue;
                if (distance[i][j] < dminn) {
                    dminn = distance[i][j];
                }
                if (!(distance[i][j] > dmaxx)) continue;
                dmaxx = distance[i][j];
            }
        }
        for (i = 0; i < front.size(); ++i) {
            double temp = 0.0;
            for (int j = 0; j < distance.length; ++j) {
                if (i == j) continue;
                temp += Math.pow(distance[i][j] - (dmaxx - dminn), 2.0);
            }
            temp /= (double)(distance.length - 1);
            temp = Math.sqrt(temp);
            temp *= -1.0;
            ((Solution)front.get(i)).attributes().put(this.getAttributeID(), temp += ((Double)((Solution)front.get(i)).attributes().get(this.getAttributeID())).doubleValue());
        }
        for (i = 0; i < distance.length; ++i) {
            Arrays.sort(distance[i]);
            double kDistance = 0.0;
            for (int k = numberOfObjectives; k > 0; --k) {
                kDistance += (dmaxx - dminn) / distance[i][k];
            }
            double temp = (Double)((Solution)front.get(i)).attributes().get(this.getAttributeID());
            ((Solution)front.get(i)).attributes().put(this.getAttributeID(), temp -= kDistance);
        }
    }

    public Object getAttributeID() {
        return this.getClass();
    }
}

